/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import dev.xkmc.modulargolems.compat.maid.GolemHealUtils;
import dev.xkmc.modulargolems.compat.maid.GolemSummonUtils;
import dev.xkmc.modulargolems.compat.maid.MaidRegistry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

class MaidManageGolemBehavior
extends Behavior<EntityMaid> {
    private static final int CD = 40;
    private static final int HCD = 20;
    private static final int MAX_DIST = 35;
    private int summonCooldown = 0;
    private int healCooldown = 0;

    public MaidManageGolemBehavior() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MaidRegistry.GOLEMS.get()), (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(worldIn, (LivingEntity)entityIn);
    }

    protected void tick(ServerLevel level, EntityMaid owner, long gameTime) {
        Optional opt = owner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (opt.isEmpty()) {
            return;
        }
        LivingEntity target = (LivingEntity)opt.get();
        CombinedInvWrapper inv = owner.getAvailableInv(false);
        ArrayList<UUID> list = new ArrayList<UUID>(owner.getBrain().getMemory((MemoryModuleType)MaidRegistry.GOLEMS.get()).orElse(List.of()));
        if (this.healCooldown > 0) {
            --this.healCooldown;
        }
        GolemHealUtils helper = new GolemHealUtils(owner, (IItemHandlerModifiable)inv);
        this.checkGolemsInLevel(level, owner, helper, (IItemHandlerModifiable)inv, list, target);
        helper.tryFixGolem();
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        } else if (GolemSummonUtils.findAndSummonGolem(level, owner, (IItemHandlerModifiable)inv, list, target)) {
            this.summonCooldown = 40;
        }
        owner.getBrain().setMemory((MemoryModuleType)MaidRegistry.GOLEMS.get(), list);
    }

    protected void stop(ServerLevel worldIn, EntityMaid self, long gameTimeIn) {
        GolemSummonUtils.collectAll(self);
    }

    private void checkGolemsInLevel(ServerLevel level, EntityMaid owner, GolemHealUtils helper, IItemHandlerModifiable inv, List<UUID> list, LivingEntity target) {
        Iterator<UUID> itr = list.iterator();
        while (itr.hasNext()) {
            UUID id = itr.next();
            Entity entity = level.getEntity(id);
            if (entity instanceof AbstractGolemEntity) {
                AbstractGolemEntity golem = (AbstractGolemEntity)entity;
                if (!golem.isAlive()) continue;
                if (this.shouldCollect(owner, golem) && GolemSummonUtils.retrieveGolem(owner, inv, golem)) {
                    itr.remove();
                    continue;
                }
                if (this.healCooldown <= 0 && helper.tryHealGolem(owner, golem)) {
                    this.healCooldown = 20;
                }
                if (golem.getTarget() == target) continue;
                golem.resetTarget(target);
                continue;
            }
            itr.remove();
        }
    }

    private boolean shouldCollect(EntityMaid owner, AbstractGolemEntity<?, ?> golem) {
        return golem.isAlive() && (golem.getHealth() < golem.getMaxHealth() * this.collectHealth(owner) || golem.distanceTo((Entity)owner) > 35.0f);
    }

    private float collectHealth(EntityMaid maid) {
        return 0.25f;
    }
}

