/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import dev.xkmc.modulargolems.compat.maid.MaidRegistry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class GolemSummonUtils {
    public static boolean findAndSummonGolem(ServerLevel level, EntityMaid owner, IItemHandlerModifiable inv, List<UUID> list, LivingEntity target) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            float hp;
            ItemStack stack = inv.getStackInSlot(i);
            if (!stack.is(MGTagGen.GOLEM_HOLDERS) || inv.extractItem(i, 1, true).isEmpty() || (hp = GolemHolder.getHealth(stack)) != -1.0f && hp < GolemSummonUtils.summonHealth(owner) * GolemHolder.getMaxHealth(stack)) continue;
            if (GolemSummonUtils.placeGolem(owner, target, list, stack)) {
                inv.extractItem(i, 1, false);
                return true;
            }
            return false;
        }
        return false;
    }

    public static void collectAll(EntityMaid owner) {
        Level level = owner.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        Optional opt = owner.getBrain().getMemory((MemoryModuleType)MaidRegistry.GOLEMS.get());
        if (opt.isEmpty()) {
            return;
        }
        List list = (List)opt.get();
        CombinedInvWrapper inv = owner.getAvailableInv(false);
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            AbstractGolemEntity golem;
            UUID id = (UUID)itr.next();
            Entity entity = sl.getEntity(id);
            if (entity instanceof AbstractGolemEntity && (golem = (AbstractGolemEntity)entity).isAlive()) {
                int index = GolemSummonUtils.getEmptySlot((IItemHandlerModifiable)inv);
                if (index < 0) break;
                ItemStack stack = golem.toItem((LivingEntity)owner);
                inv.insertItem(index, stack, false);
            }
            itr.remove();
        }
        owner.getBrain().setMemory((MemoryModuleType)MaidRegistry.GOLEMS.get(), (Object)list);
    }

    public static boolean returnToInv(EntityMaid maid, ItemStack stack) {
        CombinedInvWrapper inv = maid.getAvailableInv(false);
        int index = GolemSummonUtils.getEmptySlot((IItemHandlerModifiable)inv);
        return inv.insertItem(index, stack, false).isEmpty();
    }

    public static boolean retrieveGolem(EntityMaid owner, IItemHandlerModifiable inv, AbstractGolemEntity<?, ?> golem) {
        int index = GolemSummonUtils.getEmptySlot(inv);
        if (index < 0) {
            return false;
        }
        ItemStack stack = golem.toItem((LivingEntity)owner);
        inv.insertItem(index, stack, false);
        return true;
    }

    @Nullable
    private static BlockPos getRandomPos(Level sl, EntityType<?> type, EntityMaid owner, LivingEntity target, int r, int round) {
        BlockPos tpos = target.blockPosition();
        BlockPos opos = owner.blockPosition();
        Vec3 teye = target.getEyePosition();
        Vec3 oeye = target.getEyePosition();
        RandomSource rand = owner.getRandom();
        Vec3 diff = tpos.getCenter().subtract(opos.getCenter());
        int minDist = 4;
        int maxDist = GolemSummonUtils.getSummonRange(owner);
        double len = diff.length();
        double dist = len < (double)(maxDist - minDist) ? len / 2.0 : (len < (double)(maxDist + minDist) ? len - (double)minDist : (double)maxDist);
        BlockPos pos = BlockPos.containing((Position)opos.getCenter().add(diff.normalize().scale(dist)));
        for (int i = 0; i < round; ++i) {
            BlockPos p = pos.offset(rand.nextInt(0, r * 2 + 1) - r, 0, rand.nextInt(0, r * 2 + 1) - r);
            int h = -1;
            for (int y = 0; y < 3; ++y) {
                if (!sl.noCollision(type.getSpawnAABB((double)p.getX(), (double)(p.getY() + y), (double)p.getZ()))) continue;
                h = y;
                break;
            }
            if (h == -1) continue;
            Vec3 e = Vec3.atBottomCenterOf((Vec3i)p).add(0.0, (double)(type.getHeight() / 2.0f + (float)h), 0.0);
            BlockHitResult thit = sl.clip(new ClipContext(teye, e, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
            BlockHitResult ohit = sl.clip(new ClipContext(oeye, e, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
            if (thit.getType() != HitResult.Type.MISS || ohit.getType() != HitResult.Type.MISS) continue;
            return p;
        }
        return null;
    }

    private static boolean placeGolem(EntityMaid owner, LivingEntity target, List<UUID> list, ItemStack stack) {
        Player pl;
        Item item = stack.getItem();
        if (!(item instanceof GolemHolder)) {
            return false;
        }
        GolemHolder holder = (GolemHolder)item;
        LivingEntity livingEntity = owner.getOwner();
        Player player = livingEntity instanceof Player ? (pl = (Player)livingEntity) : null;
        BlockPos pos = GolemSummonUtils.getRandomPos(owner.level(), holder.getEntityType().type(), owner, target, 4, 6);
        if (pos == null) {
            return false;
        }
        return holder.summon(stack, owner.level(), Vec3.atBottomCenterOf((Vec3i)pos), player, e -> {
            e.setLeader((LivingEntity)owner);
            e.setMode(GolemModes.FOLLOW.getID(), BlockPos.ZERO);
            list.add(e.getUUID());
            e.resetTarget(target);
        });
    }

    private static int getEmptySlot(IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).isEmpty() || !inv.insertItem(i, GolemItems.HOLDER_GOLEM.asStack(), true).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private static float summonHealth(EntityMaid maid) {
        return 0.5f;
    }

    private static int getSummonRange(EntityMaid maid) {
        return 10;
    }
}

