/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class GolemHealUtils {
    private final EntityMaid owner;
    private final IItemHandlerModifiable inv;
    private final Map<ResourceLocation, Integer> cache = new LinkedHashMap<ResourceLocation, Integer>();

    public GolemHealUtils(EntityMaid owner, IItemHandlerModifiable inv) {
        this.owner = owner;
        this.inv = inv;
    }

    public boolean tryHealGolem(EntityMaid owner, AbstractGolemEntity<?, ?> golem) {
        ResourceLocation mat;
        int index;
        AbstractGolemEntity old;
        LivingEntity target;
        if (!this.shouldHeal(golem)) {
            return false;
        }
        Optional opt = owner.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET);
        if (opt.isPresent() && (target = (LivingEntity)opt.get()) instanceof AbstractGolemEntity && this.shouldHeal(old = (AbstractGolemEntity)target)) {
            return false;
        }
        if ((double)owner.distanceTo(golem) < 2.5 && (index = this.getIndexOfMaterial(mat = golem.getMaterials().get(MetalGolemPartType.BODY.ordinal()).id())) >= 0 && !this.inv.extractItem(index, 1, false).isEmpty()) {
            golem.repairWithItem();
            float f1 = 1.0f + (golem.getRandom().nextFloat() - golem.getRandom().nextFloat()) * 0.2f;
            golem.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, f1);
            owner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            return true;
        }
        owner.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, golem);
        return false;
    }

    public void tryFixGolem() {
        for (int slot = 0; slot < this.inv.getSlots(); ++slot) {
            int index;
            float heal;
            ItemStack stack = this.inv.getStackInSlot(slot);
            Item item = stack.getItem();
            if (!(item instanceof GolemHolder)) continue;
            GolemHolder holder = (GolemHolder)item;
            ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
            GolemType type = holder.getEntityType();
            Object part = type.getBodyPart();
            if (mats.size() <= part.ordinal()) continue;
            ResourceLocation mat = mats.get(part.ordinal()).id();
            int reforge = GolemHolder.getReforge(stack);
            if (reforge > 0) {
                int index2 = this.getIndexOfMaterial(mat);
                if (index2 < 0 || this.inv.extractItem(index2, 1, false).isEmpty()) continue;
                GolemHolder.setReforge(stack, reforge - 1);
                this.inv.setStackInSlot(slot, stack);
                continue;
            }
            float max = GolemHolder.getMaxHealth(stack);
            float health = GolemHolder.getHealth(stack);
            if (health == -1.0f || (double)health > (double)max * 0.75 || (heal = holder.getInvHeal(stack, (Entity)this.owner)) > 0.0f || (index = this.getIndexOfMaterial(mat)) < 0 || this.inv.extractItem(index, 1, false).isEmpty()) continue;
            GolemHolder.setHealth(stack, Math.min(max, health + max / 4.0f));
            this.inv.setStackInSlot(slot, stack);
        }
    }

    private boolean shouldHeal(AbstractGolemEntity<?, ?> golem) {
        if (golem.getType() != GolemTypes.ENTITY_GOLEM.get()) {
            return false;
        }
        if ((double)golem.getHealth() > (double)golem.getMaxHealth() * 0.75 && !golem.isReforged()) {
            return false;
        }
        ResourceLocation mat = golem.getMaterials().get(MetalGolemPartType.BODY.ordinal()).id();
        return this.getIndexOfMaterial(mat) >= 0;
    }

    private int getIndexOfMaterial(ResourceLocation mat) {
        Ingredient ing = GolemMaterialConfig.get().getRepairIngredient(mat);
        Integer old = this.cache.get(mat);
        if (old != null) {
            if (old == -1) {
                return -1;
            }
            ItemStack item = this.inv.getStackInSlot(old.intValue());
            if (!item.isEmpty() && ing.test(item)) {
                return old;
            }
        }
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            ItemStack item = this.inv.getStackInSlot(i);
            if (item.isEmpty() || !ing.test(item)) continue;
            this.cache.put(mat, i);
            return i;
        }
        this.cache.put(mat, -1);
        return -1;
    }
}

