/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.jei;

import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.recipe.GolemReplaceRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public record GolemReplaceExtension() implements ICraftingCategoryExtension<GolemReplaceRecipe>
{
    public void setRecipe(RecipeHolder<GolemReplaceRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        Optional<ResourceLocation> opt;
        ItemStack inStack;
        Optional in = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).findAny();
        if (in.isPresent() && (inStack = (ItemStack)((IFocus)in.get()).getTypedValue().getIngredient()).getItem() instanceof GolemPart && (opt = GolemPart.getMaterial(inStack)).isPresent()) {
            this.setRecipeSpecial(holder, builder, craftingGridHelper, inStack, opt.get());
            return;
        }
        this.setRecipeAll(holder, builder, craftingGridHelper, focuses);
    }

    private void setRecipeAll(RecipeHolder<GolemReplaceRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        GolemReplaceRecipe recipe = (GolemReplaceRecipe)holder.value();
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (Ingredient ing : recipe.getIngredients()) {
            Item item;
            ItemStack[] stacks = ing.getItems();
            if (stacks.length == 1 && (item = stacks[0].getItem()) instanceof GolemPart) {
                GolemPart part = (GolemPart)item;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
                    ItemStack stack = new ItemStack((ItemLike)part);
                    list.add(GolemPart.setMaterial(stack, rl));
                    outputs.add(recipe.assembleForJEI(rl));
                }
                inputs.add(list);
                continue;
            }
            inputs.add(List.of(stacks));
        }
        int width = this.getWidth(holder);
        int height = this.getHeight(holder);
        craftingGridHelper.createAndSetOutputs(builder, outputs);
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    private void setRecipeSpecial(RecipeHolder<GolemReplaceRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, ItemStack focusResult, ResourceLocation mat) {
        GolemReplaceRecipe recipe = (GolemReplaceRecipe)holder.value();
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        for (Ingredient ing : recipe.getIngredients()) {
            ItemStack[] stacks = ing.getItems();
            if (stacks.length == 1 && stacks[0].getItem() instanceof GolemPart) {
                inputs.add(List.of(focusResult));
                continue;
            }
            inputs.add(List.of(stacks));
        }
        int width = this.getWidth(holder);
        int height = this.getHeight(holder);
        craftingGridHelper.createAndSetOutputs(builder, List.of(recipe.assembleForJEI(mat)));
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    public int getWidth(RecipeHolder<GolemReplaceRecipe> recipeHolder) {
        return ((GolemReplaceRecipe)recipeHolder.value()).getWidth();
    }

    public int getHeight(RecipeHolder<GolemReplaceRecipe> recipeHolder) {
        return ((GolemReplaceRecipe)recipeHolder.value()).getHeight();
    }
}

