/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.jei;

import dev.xkmc.l2tabs.compat.jei.SideTabProperties;
import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.compat.jei.CustomRecipeEvent;
import dev.xkmc.modulargolems.compat.jei.GolemAddSlotExtension;
import dev.xkmc.modulargolems.compat.jei.GolemAssemblyExtension;
import dev.xkmc.modulargolems.compat.jei.GolemReplaceExtension;
import dev.xkmc.modulargolems.compat.jei.ItemFilterHandler;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.item.data.GolemHolderMaterial;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.golem.GolemFacade;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.menu.config.ToggleGolemConfigScreen;
import dev.xkmc.modulargolems.content.menu.equipment.EquipmentsScreen;
import dev.xkmc.modulargolems.content.menu.filter.ItemConfigScreen;
import dev.xkmc.modulargolems.content.menu.path.PathConfigScreen;
import dev.xkmc.modulargolems.content.menu.registry.GolemTabRegistry;
import dev.xkmc.modulargolems.content.menu.target.TargetConfigScreen;
import dev.xkmc.modulargolems.content.recipe.GolemAssembleRecipe;
import dev.xkmc.modulargolems.content.recipe.GolemReplaceRecipe;
import dev.xkmc.modulargolems.content.recipe.GolemSmithAddSlotRecipe;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@JeiPlugin
public class GolemJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = ModularGolems.loc("main");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Item item : GolemPart.LIST) {
            registration.registerSubtypeInterpreter(item, GolemJEIPlugin::partSubtype);
        }
        registration.registerSubtypeInterpreter((Item)GolemItems.FACADE.get(), GolemJEIPlugin::partSubtype);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        GolemMaterialConfig config = GolemMaterialConfig.get();
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        GolemJEIPlugin.addPartCraftRecipes(recipes, config, registration.getVanillaRecipeFactory());
        GolemJEIPlugin.addRepairRecipes(recipes, config, registration.getVanillaRecipeFactory());
        GolemJEIPlugin.addUpgradeRecipes(recipes, config, registration.getVanillaRecipeFactory());
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
        NeoForge.EVENT_BUS.post((Event)new CustomRecipeEvent(registration));
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(GolemAssembleRecipe.class, (ICraftingCategoryExtension)new GolemAssemblyExtension());
        registration.getCraftingCategory().addExtension(GolemReplaceRecipe.class, (ICraftingCategoryExtension)new GolemReplaceExtension());
        registration.getSmithingCategory().addExtension(GolemSmithAddSlotRecipe.class, (ISmithingCategoryExtension)new GolemAddSlotExtension());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(ItemConfigScreen.class, (IGhostIngredientHandler)new ItemFilterHandler());
        SideTabProperties eq = new SideTabProperties(GolemTabRegistry.EQUIPMENTS);
        eq.register(registration, new Class[]{EquipmentsScreen.class});
        new SideTabProperties(GolemTabRegistry.CONFIG).register(registration, new Class[]{ToggleGolemConfigScreen.class, ItemConfigScreen.class, TargetConfigScreen.class, PathConfigScreen.class});
        CurioCompatRegistry.onJEIRegistry(e -> eq.register(registration, new Class[]{e}));
    }

    private static String partSubtype(ItemStack stack, UidContext ctx) {
        return GolemPart.getMaterial(stack).orElse(GolemMaterial.EMPTY).toString();
    }

    private static void addPartCraftRecipes(List<IJeiAnvilRecipe> recipes, GolemMaterialConfig config, IVanillaRecipeFactory factory) {
        for (ResourceLocation mat : config.getAllMaterials()) {
            recipes.add(factory.createAnvilRecipe(GolemItems.EMPTY_UPGRADE.asStack(), List.of(config.getRepairIngredient(mat).getItems()), List.of(GolemFacade.setMaterial(GolemItems.FACADE.asStack(), mat))));
            ItemStack[] arr = config.getCraftIngredient(mat).getItems();
            boolean special = false;
            for (ItemStack stack : arr) {
                if (!stack.is(MGTagGen.SPECIAL_CRAFT)) continue;
                special = true;
                break;
            }
            if (special) continue;
            for (GolemPart golemPart : GolemPart.LIST) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ItemStack stack : arr) {
                    list.add(new ItemStack((ItemLike)stack.getItem(), golemPart.count));
                }
                recipes.add(factory.createAnvilRecipe(new ItemStack((ItemLike)golemPart), list, List.of(GolemPart.setMaterial(new ItemStack((ItemLike)golemPart), mat))));
            }
        }
    }

    private static void addRepairRecipes(List<IJeiAnvilRecipe> recipes, GolemMaterialConfig config, IVanillaRecipeFactory factory) {
        for (GolemHolder<?, ?> types : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            ArrayList<ItemStack> material = new ArrayList<ItemStack>();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (ResourceLocation mat : config.getAllMaterials()) {
                ItemStack golem = new ItemStack(types);
                ArrayList<GolemHolderMaterial.Entry> mats = new ArrayList<GolemHolderMaterial.Entry>();
                for (IGolemPart part : types.getEntityType().values()) {
                    mats.add(new GolemHolderMaterial.Entry(part.toItem(), mat));
                }
                golem = GolemItems.HOLDER_MAT.set(golem, (Object)new GolemHolderMaterial(mats));
                ItemStack damaged = golem.copy();
                input.add(GolemItems.DC_DISP_HP.set(damaged, (Object)0.75));
                ItemStack[] arr = config.getRepairIngredient(mat).getItems();
                material.add(new ItemStack((ItemLike)(arr.length > 0 ? arr[0].getItem() : Items.BARRIER)));
                result.add(GolemItems.DC_DISP_HP.set(golem, (Object)1.0));
            }
            recipes.add(factory.createAnvilRecipe(input, material, result));
        }
    }

    private static void addUpgradeRecipes(List<IJeiAnvilRecipe> recipes, GolemMaterialConfig config, IVanillaRecipeFactory factory) {
        for (GolemHolder<?, ?> golemHolder : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (UpgradeItem item : UpgradeItem.LIST) {
                arrayList.add(item.getDefaultInstance());
                result.add(GolemUpgrade.add(new ItemStack(golemHolder), item));
            }
            recipes.add(factory.createAnvilRecipe(List.of(golemHolder.getDefaultInstance()), arrayList, result));
        }
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        for (GolemHolder<?, ?> golemHolder : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
            input.add(new ItemStack(golemHolder));
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (GolemHolder<?, ?> types : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
            arrayList.add(GolemUpgrade.addSlot(new ItemStack(types), 1));
        }
        recipes.add(factory.createAnvilRecipe(input, List.of(GolemItems.ADD_SLOT.asStack()), arrayList));
        ArrayList<ItemStack> arrayList2 = new ArrayList<ItemStack>();
        for (GolemHolder<?, ?> types : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
            arrayList2.add(GolemUpgrade.addSlot(new ItemStack(types), 100));
        }
        recipes.add(factory.createAnvilRecipe(input, List.of(GolemItems.INF_SLOT.asStack()), arrayList2));
    }
}

