/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.jei;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.item.data.GolemHolderMaterial;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.recipe.GolemAssembleRecipe;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public record GolemAssemblyExtension() implements ICraftingCategoryExtension<GolemAssembleRecipe>
{
    public void setRecipe(RecipeHolder<GolemAssembleRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        ItemStack outStack;
        Item item;
        Optional out = focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).findAny();
        if (out.isPresent() && (item = (outStack = (ItemStack)((IFocus)out.get()).getTypedValue().getIngredient()).getItem()) instanceof GolemHolder) {
            GolemHolder h = (GolemHolder)item;
            if (GolemHolder.getMaterial(outStack).size() == h.getEntityType().values().length) {
                this.setRecipeSpecial(holder, builder, craftingGridHelper, outStack);
                return;
            }
        }
        this.setRecipeAll(holder, builder, craftingGridHelper, focuses);
    }

    private void setRecipeAll(RecipeHolder<GolemAssembleRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        Item stack;
        Item part;
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        for (Ingredient ing : ((GolemAssembleRecipe)holder.value()).getIngredients()) {
            Item item;
            ItemStack[] stacks = ing.getItems();
            if (stacks.length == 1 && (item = stacks[0].getItem()) instanceof GolemPart) {
                part = (GolemPart)item;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
                    stack = new ItemStack((ItemLike)part);
                    list.add(GolemPart.setMaterial((ItemStack)stack, rl));
                }
                inputs.add(list);
                continue;
            }
            inputs.add(List.of(stacks));
        }
        ItemStack resultItem = ((GolemAssembleRecipe)holder.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        part = resultItem.getItem();
        if (part instanceof GolemHolder) {
            ItemStack stack2;
            GolemHolder golem = (GolemHolder)part;
            Pair fix = null;
            Optional focus = focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).findAny();
            if (focus.isPresent() && (stack = (stack2 = (ItemStack)((IFocus)focus.get()).getTypedValue().getIngredient()).getItem()) instanceof GolemPart) {
                GolemPart part2 = (GolemPart)stack;
                Optional<ResourceLocation> mat = GolemPart.getMaterial(stack2);
                if (mat.isPresent()) {
                    fix = Pair.of((Object)part2, (Object)mat.get());
                }
            }
            for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
                stack = new ItemStack((ItemLike)golem);
                ArrayList<GolemHolderMaterial.Entry> mats = new ArrayList<GolemHolderMaterial.Entry>();
                for (IGolemPart part3 : golem.getEntityType().values()) {
                    GolemPart partItem = part3.toItem();
                    if (fix != null && fix.getFirst() == partItem) {
                        mats.add(new GolemHolderMaterial.Entry(partItem, (ResourceLocation)fix.getSecond()));
                        continue;
                    }
                    mats.add(new GolemHolderMaterial.Entry(partItem, rl));
                }
                list.add(GolemItems.HOLDER_MAT.set((ItemStack)stack, (Object)new GolemHolderMaterial(mats)));
            }
        } else {
            list.add(resultItem);
        }
        int width = this.getWidth(holder);
        int height = this.getHeight(holder);
        craftingGridHelper.createAndSetOutputs(builder, list);
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    private void setRecipeSpecial(RecipeHolder<GolemAssembleRecipe> holder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, ItemStack focusResult) {
        ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(focusResult);
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        int ind = 0;
        for (Ingredient ing : ((GolemAssembleRecipe)holder.value()).getIngredients()) {
            Item item;
            ItemStack[] stacks = ing.getItems();
            if (stacks.length == 1 && (item = stacks[0].getItem()) instanceof GolemPart) {
                GolemPart part = (GolemPart)item;
                GolemMaterial mat = mats.get(ind++);
                inputs.add(List.of(GolemPart.setMaterial(new ItemStack((ItemLike)part), mat.id())));
                continue;
            }
            inputs.add(List.of(stacks));
        }
        int width = this.getWidth(holder);
        int height = this.getHeight(holder);
        craftingGridHelper.createAndSetOutputs(builder, List.of(focusResult));
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    public int getWidth(RecipeHolder<GolemAssembleRecipe> recipeHolder) {
        return ((GolemAssembleRecipe)recipeHolder.value()).getWidth();
    }

    public int getHeight(RecipeHolder<GolemAssembleRecipe> recipeHolder) {
        return ((GolemAssembleRecipe)recipeHolder.value()).getHeight();
    }
}

