/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.jei;

import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.item.data.GolemHolderMaterial;
import dev.xkmc.modulargolems.content.item.data.GolemUpgrade;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.content.recipe.GolemSmithAddSlotRecipe;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public record GolemAddSlotExtension() implements ISmithingCategoryExtension<GolemSmithAddSlotRecipe>
{
    public <T extends IIngredientAcceptor<T>> void setTemplate(GolemSmithAddSlotRecipe r, T t) {
        t.addIngredients(r.template);
    }

    public <T extends IIngredientAcceptor<T>> void setBase(GolemSmithAddSlotRecipe r, T t) {
        Item item = r.base.getItems()[0].getItem();
        if (item instanceof GolemHolder) {
            GolemHolder golem = (GolemHolder)item;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
                ItemStack stack = new ItemStack((ItemLike)golem);
                ArrayList<GolemHolderMaterial.Entry> mats = new ArrayList<GolemHolderMaterial.Entry>();
                for (IGolemPart part : golem.getEntityType().values()) {
                    GolemPart partItem = part.toItem();
                    mats.add(new GolemHolderMaterial.Entry(partItem, rl));
                }
                ItemStack holder = GolemItems.HOLDER_MAT.set(stack, (Object)new GolemHolderMaterial(mats));
                Ingredient mat = GolemMaterialConfig.get().getRepairIngredient(rl);
                for (ItemStack ing : mat.getItems()) {
                    list.add(holder);
                }
            }
            t.addItemStacks(list);
        } else {
            t.addIngredients(r.base);
        }
    }

    public <T extends IIngredientAcceptor<T>> void setAddition(GolemSmithAddSlotRecipe r, T t) {
        if (r.base.getItems()[0].getItem() instanceof GolemHolder) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
                Ingredient mat = GolemMaterialConfig.get().getRepairIngredient(rl);
                list.addAll(List.of(mat.getItems()));
            }
            t.addItemStacks(list);
        } else {
            t.addIngredients(r.addition);
        }
    }

    public <T extends IIngredientAcceptor<T>> void setOutput(GolemSmithAddSlotRecipe r, T t) {
        Item item = r.template.getItems()[0].getItem();
        if (item instanceof IUpgradeItem) {
            IUpgradeItem item2 = (IUpgradeItem)item;
            item = r.base.getItems()[0].getItem();
            if (item instanceof GolemHolder) {
                GolemHolder golem = (GolemHolder)item;
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
                    ItemStack stack = new ItemStack((ItemLike)golem);
                    ArrayList<GolemHolderMaterial.Entry> mats = new ArrayList<GolemHolderMaterial.Entry>();
                    for (IGolemPart part : golem.getEntityType().values()) {
                        GolemPart partItem = part.toItem();
                        mats.add(new GolemHolderMaterial.Entry(partItem, rl));
                    }
                    ItemStack holder = GolemItems.HOLDER_MAT.set(stack, (Object)new GolemHolderMaterial(mats));
                    Ingredient mat = GolemMaterialConfig.get().getRepairIngredient(rl);
                    GolemUpgrade.add(holder, item2);
                    for (ItemStack ing : mat.getItems()) {
                        list.add(holder);
                    }
                }
                t.addItemStacks(list);
            }
        }
    }
}

