/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.curio;

import com.tterrag.registrate.util.entry.MenuEntry;
import dev.xkmc.l2core.init.reg.simple.Val;
import dev.xkmc.l2tabs.compat.common.CuriosEventHandler;
import dev.xkmc.l2tabs.init.data.L2TabsLangData;
import dev.xkmc.l2tabs.tabs.core.ITabScreen;
import dev.xkmc.l2tabs.tabs.core.TabToken;
import dev.xkmc.modulargolems.compat.curio.GolemCurioTab;
import dev.xkmc.modulargolems.compat.curio.GolemCuriosListMenu;
import dev.xkmc.modulargolems.compat.curio.GolemCuriosListScreen;
import dev.xkmc.modulargolems.compat.curio.GolemCuriosMenuPvd;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.menu.registry.EquipmentGroup;
import dev.xkmc.modulargolems.content.menu.registry.GolemTabRegistry;
import dev.xkmc.modulargolems.content.menu.registry.IMenuPvd;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CurioCompatRegistry {
    public static CurioCompatRegistry INSTANCE;
    public MenuEntry<GolemCuriosListMenu> menuType;
    public Val<TabToken<EquipmentGroup, GolemCurioTab>> tab;

    @Nullable
    public static CurioCompatRegistry get() {
        if (ModList.get().isLoaded("curios")) {
            if (INSTANCE == null) {
                INSTANCE = new CurioCompatRegistry();
            }
            return INSTANCE;
        }
        return null;
    }

    public static Optional<ItemStack> getItem(LivingEntity e, String slot) {
        return CuriosApi.getCuriosInventory((LivingEntity)e).flatMap(x -> x.findCurio(slot, 0).map(SlotResult::stack));
    }

    public static void register() {
        CurioCompatRegistry ins = CurioCompatRegistry.get();
        if (ins == null) {
            return;
        }
        ins.registerImpl();
    }

    public static void clientRegister() {
        CurioCompatRegistry ins = CurioCompatRegistry.get();
        if (ins == null) {
            return;
        }
        ins.clientRegisterImpl();
    }

    public static <T> void onJEIRegistry(Consumer<Class<? extends ITabScreen>> consumer) {
        CurioCompatRegistry ins = CurioCompatRegistry.get();
        if (ins == null) {
            return;
        }
        ins.onJEIRegistryImpl(consumer);
    }

    public static IMenuPvd create(AbstractGolemEntity<?, ?> entity) {
        return new GolemCuriosMenuPvd((LivingEntity)entity, 0);
    }

    public static void tryOpen(ServerPlayer player, LivingEntity target) {
        if (CurioCompatRegistry.get() == null) {
            return;
        }
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)target);
        if (opt.isEmpty()) {
            return;
        }
        if (((ICuriosItemHandler)opt.get()).getSlots() == 0) {
            return;
        }
        GolemCuriosMenuPvd pvd = new GolemCuriosMenuPvd(target, 0);
        CuriosEventHandler.openMenuWrapped((ServerPlayer)player, () -> player.openMenu((MenuProvider)pvd, pvd::writeBuffer));
    }

    public void registerImpl() {
        this.menuType = ModularGolems.REGISTRATE.menu("golem_curios", GolemCuriosListMenu::fromNetwork, () -> GolemCuriosListScreen::new).register();
        this.tab = GolemTabRegistry.TAB_REG.reg("curios", () -> GolemTabRegistry.EQUIPMENTS.registerTab(() -> GolemCurioTab::new, (Component)L2TabsLangData.CURIOS.get(new Object[0])));
    }

    public void clientRegisterImpl() {
    }

    private void onJEIRegistryImpl(Consumer<Class<? extends ITabScreen>> consumer) {
        consumer.accept(GolemCuriosListScreen.class);
    }

    public ItemStack getSkin(HumanoidGolemEntity le) {
        return CuriosApi.getCuriosInventory((LivingEntity)le).flatMap(e -> e.getStacksHandler("golem_skin")).map(ICurioStacksHandler::getStacks).map(e -> e.getSlots() == 0 ? null : e.getStackInSlot(0)).orElse(ItemStack.EMPTY);
    }
}

