/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.modintegration.curios;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.item.IOpenable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class Curios_Active {
    public static void init(RegisterCapabilitiesEvent event) {
        if (CurioChangeEvent.class != null && ICurio.class != null) {
            event.registerItem(CuriosCapability.ITEM, (stack, v) -> new EnderBagPouch((ItemStack)stack), new ItemLike[]{(ItemLike)Roster.Items.ENDERBAG.get()});
            event.registerItem(CuriosCapability.ITEM, (stack, v) -> new EnderBagPouch((ItemStack)stack), new ItemLike[]{(ItemLike)Roster.Items.ENDERPOUCH.get()});
            EnderChests.CURIO_SCANNER = (entity, type) -> {
                Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
                if (optional.isPresent()) {
                    ICuriosItemHandler handler = (ICuriosItemHandler)optional.get();
                    List list = handler.findCurios(type::test);
                    if (!list.isEmpty()) {
                        SlotResult context = (SlotResult)list.getFirst();
                        return Pair.of((Object)String.format("curio|%s|%d", context.slotContext().identifier(), context.slotContext().index()), (Object)context.stack());
                    }
                }
                return null;
            };
        }
    }

    private record EnderBagPouch(ItemStack stack) implements ICurio
    {
        public ItemStack getStack() {
            return this.stack;
        }

        public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext context, ResourceLocation slotId) {
            Multimap multimap = super.getAttributeModifiers(context, slotId);
            CuriosApi.addSlotModifier((Multimap)multimap, (String)context.identifier(), (ResourceLocation)slotId, (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
            return multimap;
        }

        public boolean canEquip(SlotContext context) {
            return EnderChests.CURIO_SCANNER.apply(context.entity(), IOpenable.Type.getFor(this.getStack())) == null && super.canEquip(context);
        }

        public boolean canUnequip(SlotContext context) {
            return !this.stack.has(DataComponents.CREATIVE_SLOT_LOCK) && super.canUnequip(context);
        }

        public void curioTick(SlotContext context) {
            Item item = this.stack.getItem();
            if (item instanceof IOpenable) {
                IOpenable openable = (IOpenable)item;
                openable.iOpenableInventoryTick(this.stack, (Entity)context.entity());
            }
        }
    }
}

