/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientHelpers;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.common.misc.StackHelper;

public class ItemEnderPouch
extends Item
implements IOpenable {
    private static final Component VANILLA_ENDER_CHEST_NAME = Component.translatable((String)"container.enderchest");

    public ItemEnderPouch(Item.Properties properties) {
        super(properties);
        SideExecutor.runOnClient(() -> () -> ClientHelpers.addProperty((Item)this, (String)"open", (stack, world, entity, seed) -> IOpenable.isOpen(stack) ? 1.0f : 0.0f));
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        StackHelper.cleanOutOldNbt(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        return this.openInventory(player.getItemInHand(hand), world, player);
    }

    @Override
    public InteractionResultHolder<ItemStack> openInventory(ItemStack stack, Level world, Player player) {
        if (((Boolean)Configs.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            IOpenable.setOpenState(stack, true);
            if (!world.isClientSide()) {
                world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), player.getSoundSource(), 1.0f, 1.0f);
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, invPlayer, entity) -> ChestMenu.threeRows((int)id, (Inventory)invPlayer, (Container)invPlayer.player.getEnderChestInventory()), VANILLA_ENDER_CHEST_NAME));
                player.awardStat(Stats.OPEN_ENDERCHEST);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        this.iOpenableInventoryTick(stack, entity);
    }

    @Override
    public boolean isContainerOpen(Player player) {
        return player != null && player.containerMenu instanceof ChestMenu;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!((Boolean)Configs.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            tooltip.add((Component)Component.literal((String)"\u00a7o").append((Component)Component.translatable((String)"info.enderchests.craftingmaterial")));
        }
    }
}

