/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.item.ItemEnderPouch;

public interface IOpenable {
    public static final Cache<ItemStack, Integer> CLOSE_DELAY = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public static boolean isOpen(ItemStack stack) {
        return stack.has(DataComponents.CREATIVE_SLOT_LOCK);
    }

    public static void setOpenState(ItemStack stack, boolean toOpen) {
        if (toOpen) {
            stack.set(DataComponents.CREATIVE_SLOT_LOCK, (Object)Unit.INSTANCE);
        } else {
            stack.remove(DataComponents.CREATIVE_SLOT_LOCK);
        }
    }

    default public void openInventory(ItemStack stack, Player player) {
        this.openInventory(stack, player.level(), player);
    }

    default public void iOpenableInventoryTick(ItemStack stack, Entity entity) {
        if (IOpenable.isOpen(stack)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Integer delay = (Integer)CLOSE_DELAY.getIfPresent((Object)stack);
                if (this.isContainerOpen(player)) {
                    if (delay == null || delay > 0) {
                        CLOSE_DELAY.put((Object)stack, (Object)-1);
                    }
                    return;
                }
                if (delay == null || delay > 0) {
                    int n;
                    if (delay == null) {
                        n = (int)(player.level().tickRateManager().tickrate() / 2.0f);
                    } else {
                        delay = delay - 1;
                        n = delay;
                    }
                    CLOSE_DELAY.put((Object)stack, (Object)n);
                    return;
                }
            }
            IOpenable.setOpenState(stack, false);
        }
    }

    public InteractionResultHolder<ItemStack> openInventory(ItemStack var1, Level var2, Player var3);

    public boolean isContainerOpen(Player var1);

    public static enum Type {
        NONE,
        EITHER,
        BAG,
        POUCH;


        public static Type getFor(ItemStack stack) {
            Item item;
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof IOpenable) {
                IOpenable openable = (IOpenable)item;
                return openable instanceof ItemEnderBag ? BAG : (openable instanceof ItemEnderPouch ? POUCH : NONE);
            }
            return NONE;
        }

        public boolean test(ItemStack stack) {
            return this.test(stack.getItem());
        }

        private boolean test(Item item) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 1 -> {
                    if (BAG.test(item) || POUCH.test(item)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> item instanceof ItemEnderBag;
                case 3 -> item instanceof ItemEnderPouch;
            };
        }
    }
}

