/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.inventory;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ContainerEnderChest
extends AbstractContainerMenu {
    private final InventoryInternal chest;
    private final Level world;
    private Component owner;
    private final DataSlot size = DataSlot.standalone();
    private Runnable callbackInventoryChange;
    private Consumer<Player> onContainerClosed;
    public final Predicate<BlockEntity> isParentTile;

    ContainerEnderChest(int id, Inventory invPlayer, TileEntityEnderChest tile) {
        super((MenuType)Roster.Containers.ENDER_CHEST.get(), id);
        this.callbackInventoryChange = () -> {};
        this.onContainerClosed = player -> {};
        this.chest = tile.getInventory();
        this.world = tile.getLevel();
        this.common_setup(invPlayer, tile.getInventory(), tile.getOwnerName());
        tile.onContainerOpen((BlockEntity)tile, (Container)this.chest, invPlayer.player);
        this.onContainerClosed = player -> tile.onContainerClosed((BlockEntity)tile, (Container)this.chest, (Player)player);
        this.isParentTile = input -> tile == input;
    }

    ContainerEnderChest(int id, Inventory invPlayer, InventoryInternal chest, String owner) {
        super((MenuType)Roster.Containers.ENDER_BAG.get(), id);
        this.callbackInventoryChange = () -> {};
        this.onContainerClosed = player -> {};
        this.chest = chest;
        this.world = invPlayer.player.level();
        this.common_setup(invPlayer, chest, owner);
        this.isParentTile = input -> false;
    }

    private void common_setup(Inventory invPlayer, InventoryInternal chest, String owner) {
        int slotId;
        this.owner = ChestInfoHelper.infoChestOwner(owner, true);
        for (slotId = 0; slotId < 54; ++slotId) {
            this.addSlot(new Slots.Hideable((Container)chest, slotId, 0, 0));
        }
        for (slotId = 0; slotId < 27; ++slotId) {
            this.addSlot(new Slot((Container)invPlayer, slotId + 9, 0, 0));
        }
        for (slotId = 0; slotId < 9; ++slotId) {
            this.addSlot(new Slot((Container)invPlayer, slotId, 0, 0));
        }
        this.addDataSlot(this.size).set(this.chest.getContainerSize());
    }

    public void broadcastChanges() {
        this.size.set(this.chest.getContainerSize());
        super.broadcastChanges();
    }

    public void setData(int id, int value) {
        super.setData(id, value);
        if (this.world.isClientSide && this.size.get() != this.chest.getContainerSize()) {
            String name = this.chest.getNameKey();
            String[] parts = name.split("\\.");
            if (parts.length == 2) {
                ChestHelper.setCapacity(this.world, parts[0], parts[1], (byte)value);
                this.callbackInventoryChange.run();
            } else if (parts.length == 4) {
                ChestHelper.setCapacity(this.world, parts[2], parts[3], (byte)value);
                this.callbackInventoryChange.run();
            }
        }
    }

    public void setInventoryChangeCallback(Runnable runnable) {
        this.callbackInventoryChange = runnable;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        ItemStack stack;
        if (clickType == ClickType.SWAP && dragType >= 0 && dragType < 9 && !(stack = player.getInventory().getItem(dragType)).isEmpty() && stack.getItem() instanceof IOpenable && IOpenable.isOpen(stack)) {
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.onContainerClosed.accept(player);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int slotNumber) {
        Slot clickedSlot = (Slot)this.slots.get(slotNumber);
        if (clickedSlot == null || !clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemInSlot = clickedSlot.getItem();
        if (itemInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack returnStack = itemInSlot.copy();
        if (slotNumber < 54 ? !this.moveItemStackTo(itemInSlot, 54, this.slots.size(), true) : !this.moveItemStackTo(itemInSlot, 0, this.chest.getContainerSize(), false)) {
            return ItemStack.EMPTY;
        }
        if (itemInSlot.getCount() == 0) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        if (itemInSlot.getCount() == returnStack.getCount()) {
            return ItemStack.EMPTY;
        }
        return returnStack;
    }

    public int getChestSize() {
        return this.chest.getContainerSize();
    }

    public Component getOwner() {
        return this.owner;
    }
}

