/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.platform.Services;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class RenderEnderChest
implements BlockEntityRenderer<TileEntityEnderChest> {
    private static final BlockColors BLOCK_COLORS = Minecraft.getInstance().getBlockColors();
    private static final ModelBlockRenderer RENDERER = new ModelBlockRenderer(BLOCK_COLORS);

    public void render(TileEntityEnderChest tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = tile.getBlockState();
        if (tile.getLevel() == null || !state.hasProperty((Property)BlockEnderChest.STATIC)) {
            return;
        }
        state = (BlockState)state.setValue((Property)BlockEnderChest.STATIC, (Comparable)Boolean.valueOf(false));
        float lidAngle = tile.getLidAngle(partialTicks);
        lidAngle *= 0.7f;
        BakedModel model = blockRenderer.getBlockModelShaper().getBlockModel(state);
        Direction facing = BlockEnderChest.getFacing(state);
        if (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            lidAngle = -lidAngle;
        }
        matrixStack.pushPose();
        switch (facing.getAxis()) {
            case X: {
                matrixStack.translate(lidAngle, 0.0f, 0.0f);
                break;
            }
            case Y: {
                matrixStack.translate(0.0f, lidAngle, 0.0f);
                break;
            }
            case Z: {
                matrixStack.translate(0.0f, 0.0f, lidAngle);
            }
        }
        int color = BLOCK_COLORS.getColor(state, null, null, 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Services.CLIENT.renderModel(RENDERER, matrixStack.last(), buffer.getBuffer(Sheets.cutoutBlockSheet()), state, model, red, green, blue, combinedLight, combinedOverlay, RenderData.EMPTY, null);
        matrixStack.popPose();
    }
}

