/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Helpers;
import shetiphian.core.platform.Services;
import shetiphian.enderchests.Configs;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.network.PacketOpenBag;

class EventHandlerClient {
    public static final KeyMapping KEY_OPEN_BAG = new KeyMapping("key.enderchests.open.bag", -1, "itemGroup.enderchests");
    public static final KeyMapping KEY_OPEN_POUCH = new KeyMapping("key.enderchests.open.pouch", -1, "itemGroup.enderchests");

    EventHandlerClient() {
    }

    protected void onClientTick() {
        if (KEY_OPEN_BAG.consumeClick()) {
            this.openCarriedBag(KEY_OPEN_BAG.same(KEY_OPEN_POUCH) ? IOpenable.Type.EITHER : IOpenable.Type.BAG);
        } else if (KEY_OPEN_POUCH.consumeClick()) {
            this.openCarriedBag(KEY_OPEN_BAG.same(KEY_OPEN_POUCH) ? IOpenable.Type.EITHER : IOpenable.Type.POUCH);
        }
    }

    private void openCarriedBag(IOpenable.Type type) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Item item;
            Pair<String, ItemStack> curioData = EnderChests.CURIO_SCANNER.apply((LivingEntity)player, type);
            if (curioData != null && (item = ((ItemStack)curioData.getSecond()).getItem()) instanceof IOpenable) {
                IOpenable openable = (IOpenable)item;
                openable.openInventory((ItemStack)curioData.getSecond(), (Player)player);
                Services.NETWORK.sendToServer((CustomPacketPayload)new PacketOpenBag((String)curioData.getFirst(), type));
                return;
            }
            NonNullList items = player.getInventory().items;
            for (int index = items.size() - 1; index >= 0; --index) {
                Item item2;
                ItemStack stack = (ItemStack)items.get(index);
                if (stack.isEmpty() || !((item2 = stack.getItem()) instanceof IOpenable)) continue;
                IOpenable openable = (IOpenable)item2;
                if (!type.test(stack)) continue;
                openable.openInventory(stack, (Player)player);
                Services.NETWORK.sendToServer((CustomPacketPayload)new PacketOpenBag(String.format("inventory|%d", index), type));
                break;
            }
        }
    }

    void onDrawBlockHighlight(BlockHitResult target, PoseStack matrix, MultiBufferSource buffers, Camera camera) {
        VoxelShape shape;
        BlockPos pos;
        if (target == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.isShiftKeyDown() || player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
            return;
        }
        Level world = player.level();
        BlockState state = world.getBlockState(pos = target.getBlockPos());
        if (state.getBlock() instanceof BlockEnderChest && world.getWorldBorder().isWithinBounds(pos) && !(shape = this.getShapeToOutline((Player)player, state, world, pos)).isEmpty()) {
            this.drawSelectionBox(matrix, buffers.getBuffer(RenderType.lines()), camera, pos, shape);
        }
    }

    private VoxelShape getShapeToOutline(Player player, BlockState state, Level world, BlockPos pos) {
        for (InteractionHand hand : InteractionHand.values()) {
            Item item = player.getItemInHand(hand).getItem();
            if (Configs.PROCESSED.listPersonal.contains(item) || Configs.PROCESSED.listTeam.contains(item) || Configs.PROCESSED.listSmallCap_Single.contains(item) || Configs.PROCESSED.listSmallCap_Multi.contains(item) || Configs.PROCESSED.listLargeCap_Single.contains(item) || Configs.PROCESSED.listLargeCap_Multi.contains(item)) {
                return state.getShape((BlockGetter)world, pos);
            }
            if (!DyeHelper.isDye((Item)item) || BlockEnderChest.SHAPES.isEmpty()) continue;
            VoxelShape[] shapes = BlockEnderChest.SHAPES.get(state.getValue((Property)BlockEnderChest.FACING));
            int subHit = Helpers.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])shapes);
            return subHit > 0 && subHit < 4 ? shapes[subHit] : Shapes.empty();
        }
        return Shapes.empty();
    }

    private void drawSelectionBox(PoseStack matrix, VertexConsumer buffer, Camera info, BlockPos pos, VoxelShape shape) {
        double d0 = info.getPosition().x;
        double d1 = info.getPosition().y;
        double d2 = info.getPosition().z;
        float mul = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
        if (mul > 1.0f) {
            mul = 2.0f - mul;
        }
        this.drawShape(matrix, buffer, shape, (double)pos.getX() - d0, (double)pos.getY() - d1, (double)pos.getZ() - d2, mul, mul, mul, 0.4f);
    }

    private void drawShape(PoseStack matrix, VertexConsumer buffer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = matrix.last();
        shape.forAllEdges((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float nX = (float)(maxX - minX);
            float nY = (float)(maxY - minY);
            float nZ = (float)(maxZ - minZ);
            float sqrt = Mth.sqrt((float)(nX * nX + nY * nY + nZ * nZ));
            buffer.addVertex(pose.pose(), (float)(minX + x), (float)(minY + y), (float)(minZ + z)).setColor(red, green, blue, alpha).setNormal(pose, nX /= sqrt, nY /= sqrt, nZ /= sqrt);
            buffer.addVertex(pose.pose(), (float)(maxX + x), (float)(maxY + y), (float)(maxZ + z)).setColor(red, green, blue, alpha).setNormal(pose, nX, nY, nZ);
        });
    }
}

