/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.world.item.ItemStack;

public class ItemStackComponent
implements RecipeComponent<ItemStack> {
    public static final ItemStackComponent ITEM_STACK = new ItemStackComponent("item_stack", (Codec<ItemStack>)ItemStack.OPTIONAL_CODEC);
    public static final ItemStackComponent STRICT_ITEM_STACK = new ItemStackComponent("strict_item_stack", (Codec<ItemStack>)ItemStack.STRICT_CODEC);
    public final String name;
    public final Codec<ItemStack> codec;

    public ItemStackComponent(String name, Codec<ItemStack> codec) {
        this.name = name;
        this.codec = codec;
    }

    @Override
    public Codec<ItemStack> codec() {
        return ItemStack.OPTIONAL_CODEC;
    }

    @Override
    public TypeInfo typeInfo() {
        return ItemStackJS.TYPE_INFO;
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        return ItemStackJS.isItemStackLike(from);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(Context cx, KubeRecipe recipe, ItemStack value, ReplacementMatchInfo match) {
        ReplacementMatch replacementMatch = match.match();
        if (!(replacementMatch instanceof ItemMatch)) return false;
        ItemMatch m = (ItemMatch)replacementMatch;
        if (value.isEmpty()) return false;
        if (!m.matches(cx, value, match.exact())) return false;
        return true;
    }

    @Override
    public boolean isEmpty(ItemStack value) {
        return value.isEmpty();
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, ItemStack value) {
        if (!value.isEmpty()) {
            builder.append(value.kjs$getIdLocation());
        }
    }

    public String toString() {
        return this.name;
    }
}

