/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.core.PlayerKJS;
import dev.latvian.mods.kubejs.gui.KubeJSGUI;
import dev.latvian.mods.kubejs.gui.KubeJSMenu;
import dev.latvian.mods.kubejs.gui.chest.ChestMenuData;
import dev.latvian.mods.kubejs.gui.chest.CustomChestMenu;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.net.NotificationPayload;
import dev.latvian.mods.kubejs.net.SendDataFromServerPayload;
import dev.latvian.mods.kubejs.net.SetActivePostShaderPayload;
import dev.latvian.mods.kubejs.player.PlayerStatsJS;
import dev.latvian.mods.kubejs.util.NotificationToastData;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface ServerPlayerKJS
extends PlayerKJS {
    default public ServerPlayer kjs$self() {
        return (ServerPlayer)this;
    }

    @Override
    default public void kjs$sendData(String channel, @Nullable CompoundTag data) {
        if (!channel.isEmpty()) {
            PacketDistributor.sendToPlayer((ServerPlayer)this.kjs$self(), (CustomPacketPayload)new SendDataFromServerPayload(channel, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    default public PlayerStatsJS kjs$getStats() {
        return new PlayerStatsJS((Player)this.kjs$self(), (StatsCounter)this.kjs$self().getStats());
    }

    @Override
    default public boolean kjs$isMiningBlock() {
        return this.kjs$self().gameMode.isDestroyingBlock;
    }

    @Override
    default public void kjs$setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        PlayerKJS.super.kjs$setPositionAndRotation(x, y, z, yaw, pitch);
        this.kjs$self().connection.teleport(x, y, z, yaw, pitch);
    }

    default public void kjs$setCreativeMode(boolean mode) {
        this.kjs$self().setGameMode(mode ? GameType.CREATIVE : GameType.SURVIVAL);
    }

    default public boolean kjs$isOp() {
        return this.kjs$self().server.getPlayerList().isOp(this.kjs$self().getGameProfile());
    }

    default public void kjs$kick(Component reason) {
        this.kjs$self().connection.disconnect(reason);
    }

    default public void kjs$kick() {
        this.kjs$kick((Component)Component.translatable((String)"multiplayer.disconnect.kicked"));
    }

    default public void kjs$ban(String banner, String reason, long expiresInMillis) {
        Date date = new Date();
        UserBanListEntry userlistbansentry = new UserBanListEntry(this.kjs$self().getGameProfile(), date, banner, new Date(date.getTime() + (expiresInMillis <= 0L ? 315569260000L : expiresInMillis)), reason);
        this.kjs$self().server.getPlayerList().getBans().add((StoredUserEntry)userlistbansentry);
        this.kjs$kick((Component)Component.translatable((String)"multiplayer.disconnect.banned"));
    }

    default public boolean kjs$isAdvancementDone(ResourceLocation id) {
        AdvancementNode a = this.kjs$self().server.kjs$getAdvancement(id);
        return a != null && this.kjs$self().getAdvancements().getOrStartProgress(a.holder()).isDone();
    }

    default public void kjs$unlockAdvancement(ResourceLocation id) {
        AdvancementNode a = this.kjs$self().server.kjs$getAdvancement(id);
        if (a != null) {
            AdvancementProgress advancementprogress = this.kjs$self().getAdvancements().getOrStartProgress(a.holder());
            for (String s : advancementprogress.getRemainingCriteria()) {
                this.kjs$self().getAdvancements().award(a.holder(), s);
            }
        }
    }

    default public void kjs$revokeAdvancement(ResourceLocation id) {
        AdvancementProgress advancementprogress;
        AdvancementNode a = this.kjs$self().server.kjs$getAdvancement(id);
        if (a != null && (advancementprogress = this.kjs$self().getAdvancements().getOrStartProgress(a.holder())).hasProgress()) {
            for (String s : advancementprogress.getCompletedCriteria()) {
                this.kjs$self().getAdvancements().revoke(a.holder(), s);
            }
        }
    }

    @Override
    default public void kjs$setSelectedSlot(int index) {
        int p = this.kjs$getSelectedSlot();
        PlayerKJS.super.kjs$setSelectedSlot(index);
        int n = this.kjs$getSelectedSlot();
        if (p != n && this.kjs$self().connection != null) {
            this.kjs$self().connection.send((Packet)new ClientboundSetCarriedItemPacket(n));
        }
    }

    @Override
    default public void kjs$setMouseItem(ItemStack item) {
        PlayerKJS.super.kjs$setMouseItem(item);
        if (this.kjs$self().connection != null) {
            this.kjs$self().inventoryMenu.broadcastChanges();
        }
    }

    @Nullable
    default public BlockContainerJS kjs$getSpawnLocation() {
        BlockPos pos = this.kjs$self().getRespawnPosition();
        return pos == null ? null : new BlockContainerJS(this.kjs$getLevel(), pos);
    }

    default public void kjs$setSpawnLocation(BlockContainerJS c) {
        this.kjs$self().setRespawnPosition(c.minecraftLevel.dimension(), c.getPos(), 0.0f, true, false);
    }

    @Override
    default public void kjs$notify(NotificationToastData builder) {
        PacketDistributor.sendToPlayer((ServerPlayer)this.kjs$self(), (CustomPacketPayload)new NotificationPayload(builder), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    default public void kjs$openChestGUI(Consumer<KubeJSGUI> gui) {
        final KubeJSGUI data = new KubeJSGUI();
        gui.accept(data);
        this.kjs$self().openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return data.title;
            }

            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                return new KubeJSMenu(i, inventory, data);
            }
        }, data::write);
    }

    default public void kjs$openInventoryGUI(InventoryKJS inventory, Component title) {
        this.kjs$openChestGUI(gui -> {
            gui.title = title;
            gui.setInventory(inventory);
        });
    }

    default public Container kjs$captureInventory(boolean autoRestore) {
        NonNullList playerItems = this.kjs$self().getInventory().items;
        SimpleContainer captured = new SimpleContainer(playerItems.size());
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < playerItems.size(); ++i) {
            ItemStack c = (ItemStack)playerItems.set(i, (Object)ItemStack.EMPTY);
            if (c.isEmpty()) continue;
            if (autoRestore) {
                map.put(i, c);
            }
            captured.setItem(i, c.copy());
        }
        if (autoRestore && !map.isEmpty()) {
            this.kjs$self().getServer().kjs$restoreInventories().put(this.kjs$self().getUUID(), map);
        }
        return captured;
    }

    /*
     * Enabled aggressive block sorting
     */
    default public void kjs$openChestGUI(final Component title, int rows, Consumer<ChestMenuData> gui) {
        CustomChestMenu open;
        final ChestMenuData data = new ChestMenuData(this.kjs$self(), title, Mth.clamp((int)rows, (int)1, (int)6));
        gui.accept(data);
        AbstractContainerMenu abstractContainerMenu = this.kjs$self().containerMenu;
        if (abstractContainerMenu instanceof CustomChestMenu) {
            open = (CustomChestMenu)abstractContainerMenu;
            data.capturedInventory = open.data.capturedInventory;
        } else {
            data.capturedInventory = this.kjs$captureInventory(true);
        }
        abstractContainerMenu = this.kjs$self().containerMenu;
        if (abstractContainerMenu instanceof CustomChestMenu) {
            open = (CustomChestMenu)abstractContainerMenu;
            if (open.data.rows == data.rows && open.data.title.equals((Object)title)) {
                open.data = data;
                data.sync();
                return;
            }
        }
        data.sync();
        this.kjs$self().openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return title;
            }

            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                return new CustomChestMenu(i, data);
            }
        });
    }

    default public void kjs$heal() {
        this.kjs$self().heal(this.kjs$self().getMaxHealth());
        this.kjs$self().getFoodData().eat(20, 1.0f);
    }

    @Override
    default public void kjs$setActivePostShader(@Nullable ResourceLocation id) {
        PacketDistributor.sendToPlayer((ServerPlayer)this.kjs$self(), (CustomPacketPayload)new SetActivePostShaderPayload(Optional.ofNullable(id)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

