/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.unfocused.registry;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0018\b\u0002\u0010\t\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\u0016\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\rJ\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J \u0010\u001d\u001a\u0013\u0012\u000f\u0012\r\u0012\u0004\u0012\u00028\u00000\u001b\u00a2\u0006\u0002\b\u001c0\u001aH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ!\u0010 \u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00028\u00000\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J \u0010#\u001a\u0013\u0012\u000f\u0012\r\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\b\u001c0\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010*\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0016\u00a2\u0006\u0004\b*\u0010+J\u001d\u0010-\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016\u00a2\u0006\u0004\b-\u0010.J#\u0010-\u001a\u00020\u00172\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070/H\u0016\u00a2\u0006\u0004\b-\u00101J\u001d\u0010-\u001a\u00020\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016\u00a2\u0006\u0004\b-\u00103J\u0017\u0010-\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b-\u00105J\u001d\u0010-\u001a\u00020\u00172\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0017\u00a2\u0006\u0004\b-\u00107R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00108\u001a\u0004\b9\u0010:R\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010;\u001a\u0004\b<\u0010=R'\u0010\t\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\b\u0018\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010>\u001a\u0004\b?\u0010@R$\u0010\u0016\u001a\u0004\u0018\u00018\u00008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010A\u001a\u0004\bB\u0010\r\"\u0004\bC\u0010DR*\u0010E\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010>\u001a\u0004\bF\u0010@\"\u0004\bG\u0010HR.\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0I8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\"\u0010P\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0O8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010Q\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006R"}, d2={"Lcom/ssblur/unfocused/registry/RegistrySupplier;", "T", "Ljava/util/function/Supplier;", "Lnet/minecraft/core/Holder;", "supplier", "Lnet/minecraft/resources/ResourceLocation;", "location", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "registryKey", "<init>", "(Ljava/util/function/Supplier;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceKey;)V", "get", "()Ljava/lang/Object;", "Ljava/util/function/Consumer;", "consumer", "", "then", "(Ljava/util/function/Consumer;)V", "Lnet/minecraft/core/Holder$Reference;", "ref", "()Lnet/minecraft/core/Holder$Reference;", "value", "", "isBound", "()Z", "Ljava/util/stream/Stream;", "Lnet/minecraft/tags/TagKey;", "Lkotlin/jvm/internal/EnhancedNullability;", "tags", "()Ljava/util/stream/Stream;", "Lcom/mojang/datafixers/util/Either;", "unwrap", "()Lcom/mojang/datafixers/util/Either;", "Ljava/util/Optional;", "unwrapKey", "()Ljava/util/Optional;", "Lnet/minecraft/core/Holder$Kind;", "kind", "()Lnet/minecraft/core/Holder$Kind;", "Lnet/minecraft/core/HolderOwner;", "holderOwner", "canSerializeIn", "(Lnet/minecraft/core/HolderOwner;)Z", "tagKey", "is", "(Lnet/minecraft/tags/TagKey;)Z", "Ljava/util/function/Predicate;", "predicate", "(Ljava/util/function/Predicate;)Z", "resourceKey", "(Lnet/minecraft/resources/ResourceKey;)Z", "resourceLocation", "(Lnet/minecraft/resources/ResourceLocation;)Z", "holder", "(Lnet/minecraft/core/Holder;)Z", "Ljava/util/function/Supplier;", "getSupplier", "()Ljava/util/function/Supplier;", "Lnet/minecraft/resources/ResourceLocation;", "getLocation", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/resources/ResourceKey;", "getRegistryKey", "()Lnet/minecraft/resources/ResourceKey;", "Ljava/lang/Object;", "getValue", "setValue", "(Ljava/lang/Object;)V", "key", "getKey", "setKey", "(Lnet/minecraft/resources/ResourceKey;)V", "", "Ljava/util/Set;", "getTags", "()Ljava/util/Set;", "setTags", "(Ljava/util/Set;)V", "", "pending", "Ljava/util/List;", "unfocused-common"})
@SourceDebugExtension(value={"SMAP\nRegistrySupplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistrySupplier.kt\ncom/ssblur/unfocused/registry/RegistrySupplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1863#2,2:69\n1#3:71\n*S KotlinDebug\n*F\n+ 1 RegistrySupplier.kt\ncom/ssblur/unfocused/registry/RegistrySupplier\n*L\n36#1:69,2\n*E\n"})
public final class RegistrySupplier<T>
implements Supplier<T>,
Holder<T> {
    @NotNull
    private final Supplier<T> supplier;
    @Nullable
    private final ResourceLocation location;
    @Nullable
    private final ResourceKey<? extends Registry<T>> registryKey;
    @Nullable
    private T value;
    @Nullable
    private ResourceKey<T> key;
    @NotNull
    private Set<TagKey<T>> tags;
    @NotNull
    private List<Consumer<T>> pending;

    public RegistrySupplier(@NotNull Supplier<T> supplier, @Nullable ResourceLocation location, @Nullable ResourceKey<? extends Registry<T>> registryKey) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        this.supplier = supplier;
        this.location = location;
        this.registryKey = registryKey;
        this.tags = new LinkedHashSet();
        this.pending = new ArrayList();
        if (this.location != null && this.registryKey != null) {
            this.key = ResourceKey.create(this.registryKey, (ResourceLocation)this.location);
        }
    }

    public /* synthetic */ RegistrySupplier(Supplier supplier, ResourceLocation resourceLocation, ResourceKey resourceKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            resourceLocation = null;
        }
        if ((n & 4) != 0) {
            resourceKey = null;
        }
        this(supplier, resourceLocation, resourceKey);
    }

    @NotNull
    public final Supplier<T> getSupplier() {
        return this.supplier;
    }

    @Nullable
    public final ResourceLocation getLocation() {
        return this.location;
    }

    @Nullable
    public final ResourceKey<? extends Registry<T>> getRegistryKey() {
        return this.registryKey;
    }

    @Nullable
    public final T getValue() {
        return this.value;
    }

    public final void setValue(@Nullable T t) {
        this.value = t;
    }

    @Nullable
    public final ResourceKey<T> getKey() {
        return this.key;
    }

    public final void setKey(@Nullable ResourceKey<T> resourceKey) {
        this.key = resourceKey;
    }

    @NotNull
    public final Set<TagKey<T>> getTags() {
        return this.tags;
    }

    public final void setTags(@NotNull Set<TagKey<T>> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.tags = set;
    }

    @Override
    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
            Iterable $this$forEach$iv = this.pending;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Consumer it = (Consumer)element$iv;
                boolean bl = false;
                T t = this.value;
                Intrinsics.checkNotNull(t);
                it.accept(t);
            }
            this.pending = new ArrayList();
        }
        T t = this.value;
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final void then(@NotNull Consumer<T> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.value == null) {
            ((Collection)this.pending).add(consumer);
        } else {
            T t = this.value;
            Intrinsics.checkNotNull(t);
            consumer.accept(t);
        }
    }

    @NotNull
    public final Holder.Reference<T> ref() {
        Holder.Reference reference;
        ResourceLocation resourceLocation = this.location;
        if (resourceLocation != null) {
            ResourceLocation it = resourceLocation;
            boolean bl = false;
            ResourceKey<? extends Registry<T>> resourceKey = this.registryKey;
            Intrinsics.checkNotNull(resourceKey);
            Object object = (Registry)BuiltInRegistries.REGISTRY.get(resourceKey.location());
            reference = object != null && (object = object.getHolder(it)) != null ? (Holder.Reference)OptionalsKt.getOrNull((Optional)object) : null;
        } else {
            reference = null;
        }
        Intrinsics.checkNotNull(reference, (String)"null cannot be cast to non-null type net.minecraft.core.Holder.Reference<T of com.ssblur.unfocused.registry.RegistrySupplier>");
        return reference;
    }

    @NotNull
    public T value() {
        T t = this.get();
        Intrinsics.checkNotNull(t);
        return t;
    }

    public boolean isBound() {
        return true;
    }

    @NotNull
    public Stream<TagKey<T>> tags() {
        Stream<TagKey<T>> stream = this.tags.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    @NotNull
    public Either<ResourceKey<T>, T> unwrap() {
        Either either = Either.right(this.value);
        Intrinsics.checkNotNullExpressionValue((Object)either, (String)"right(...)");
        return either;
    }

    @NotNull
    public Optional<ResourceKey<T>> unwrapKey() {
        Optional<ResourceKey<T>> optional = Optional.ofNullable(this.key);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public Holder.Kind kind() {
        return Holder.Kind.DIRECT;
    }

    public boolean canSerializeIn(@NotNull HolderOwner<T> holderOwner) {
        Intrinsics.checkNotNullParameter(holderOwner, (String)"holderOwner");
        return true;
    }

    public boolean is(@NotNull TagKey<T> tagKey) {
        Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
        return this.tags().anyMatch(arg_0 -> RegistrySupplier.is$lambda$3(arg_0 -> RegistrySupplier.is$lambda$2(tagKey, arg_0), arg_0));
    }

    public boolean is(@NotNull Predicate<ResourceKey<T>> predicate) {
        boolean bl;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ResourceKey<T> resourceKey = this.key;
        if (resourceKey != null) {
            ResourceKey<T> it = resourceKey;
            boolean bl2 = false;
            bl = predicate.test(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean is(@NotNull ResourceKey<T> resourceKey) {
        Intrinsics.checkNotNullParameter(resourceKey, (String)"resourceKey");
        return Intrinsics.areEqual(resourceKey, this.key);
    }

    public boolean is(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        return Intrinsics.areEqual((Object)resourceLocation, (Object)this.location);
    }

    @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="equals", imports={}))
    public boolean is(@NotNull Holder<T> holder) {
        boolean bl;
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        ResourceLocation resourceLocation = this.location;
        if (resourceLocation != null) {
            ResourceLocation it = resourceLocation;
            boolean bl2 = false;
            bl = holder.is(it);
        } else {
            bl = this.isBound() && holder.isBound() && Intrinsics.areEqual(this.value(), (Object)holder.value());
        }
        return bl;
    }

    private static final boolean is$lambda$2(TagKey $tagKey, TagKey it) {
        Intrinsics.checkNotNullParameter((Object)$tagKey, (String)"$tagKey");
        return Intrinsics.areEqual((Object)it, (Object)$tagKey);
    }

    private static final boolean is$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

