/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.unfocused.registry;

import com.ssblur.unfocused.registry.RegistrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002#$B#\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0012\u001a\u00020\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R#\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R3\u0010\u001d\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001aj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b`\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R3\u0010!\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u001aj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f`\u001c8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b\"\u0010 \u00a8\u0006%"}, d2={"Lcom/ssblur/unfocused/registry/Registry;", "A", "", "", "id", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "key", "<init>", "(Ljava/lang/String;Lnet/minecraft/resources/ResourceKey;)V", "Ljava/util/function/Supplier;", "supplier", "Lcom/ssblur/unfocused/registry/RegistrySupplier;", "register", "(Ljava/lang/String;Ljava/util/function/Supplier;)Lcom/ssblur/unfocused/registry/RegistrySupplier;", "Lcom/ssblur/unfocused/registry/Registry$Subscriber;", "subscriber", "", "subscribe", "(Lcom/ssblur/unfocused/registry/Registry$Subscriber;)V", "Ljava/lang/String;", "getId", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceKey;", "getKey", "()Lnet/minecraft/resources/ResourceKey;", "Ljava/util/ArrayList;", "Lcom/ssblur/unfocused/registry/Registry$RegistryEntry;", "Lkotlin/collections/ArrayList;", "entries", "Ljava/util/ArrayList;", "getEntries", "()Ljava/util/ArrayList;", "subscribers", "getSubscribers", "Subscriber", "RegistryEntry", "unfocused-common"})
@SourceDebugExtension(value={"SMAP\nRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Registry.kt\ncom/ssblur/unfocused/registry/Registry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1863#2,2:37\n1863#2,2:39\n*S KotlinDebug\n*F\n+ 1 Registry.kt\ncom/ssblur/unfocused/registry/Registry\n*L\n24#1:37,2\n29#1:39,2\n*E\n"})
public final class Registry<A> {
    @NotNull
    private final String id;
    @NotNull
    private final ResourceKey<net.minecraft.core.Registry<A>> key;
    @NotNull
    private final ArrayList<RegistryEntry<A>> entries;
    @NotNull
    private final ArrayList<Subscriber<A>> subscribers;

    public Registry(@NotNull String id, @NotNull ResourceKey<net.minecraft.core.Registry<A>> key) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.id = id;
        this.key = key;
        this.entries = new ArrayList();
        this.subscribers = new ArrayList();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ResourceKey<net.minecraft.core.Registry<A>> getKey() {
        return this.key;
    }

    @NotNull
    public final ArrayList<RegistryEntry<A>> getEntries() {
        return this.entries;
    }

    @NotNull
    public final ArrayList<Subscriber<A>> getSubscribers() {
        return this.subscribers;
    }

    @NotNull
    public final RegistrySupplier<A> register(@NotNull String id, @NotNull Supplier<A> supplier) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        RegistrySupplier<A> registrySupplier = new RegistrySupplier<A>(supplier, ResourceLocation.fromNamespaceAndPath((String)this.id, (String)id), this.key);
        ((Collection)this.entries).add(new RegistryEntry(id, registrySupplier));
        Iterable $this$forEach$iv = this.subscribers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Subscriber it = (Subscriber)element$iv;
            boolean bl = false;
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)this.id, (String)id);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
            it.onRegistered(resourceLocation, registrySupplier);
        }
        return registrySupplier;
    }

    public final void subscribe(@NotNull Subscriber<A> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegistryEntry it = (RegistryEntry)element$iv;
            boolean bl = false;
            if (!it.getRegistered()) {
                ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)this.id, (String)it.getId());
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
                subscriber.onRegistered(resourceLocation, it.getSupplier());
            }
            it.setRegistered(true);
        }
        ((Collection)this.subscribers).add(subscriber);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\f\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/ssblur/unfocused/registry/Registry$RegistryEntry;", "T", "", "", "id", "Ljava/util/function/Supplier;", "supplier", "<init>", "(Ljava/lang/String;Ljava/util/function/Supplier;)V", "Ljava/lang/String;", "getId", "()Ljava/lang/String;", "Ljava/util/function/Supplier;", "getSupplier", "()Ljava/util/function/Supplier;", "", "registered", "Z", "getRegistered", "()Z", "setRegistered", "(Z)V", "unfocused-common"})
    public static final class RegistryEntry<T> {
        @NotNull
        private final String id;
        @NotNull
        private final Supplier<T> supplier;
        private boolean registered;

        public RegistryEntry(@NotNull String id, @NotNull Supplier<T> supplier) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            this.id = id;
            this.supplier = supplier;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Supplier<T> getSupplier() {
            return this.supplier;
        }

        public final boolean getRegistered() {
            return this.registered;
        }

        public final void setRegistered(boolean bl) {
            this.registered = bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J%\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005H&\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/ssblur/unfocused/registry/Registry$Subscriber;", "T", "", "Lnet/minecraft/resources/ResourceLocation;", "location", "Ljava/util/function/Supplier;", "supplier", "", "onRegistered", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/function/Supplier;)V", "unfocused-common"})
    public static interface Subscriber<T> {
        public void onRegistered(@NotNull ResourceLocation var1, @NotNull Supplier<T> var2);
    }
}

