/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.unfocused.neoforge.events;

import com.mojang.brigadier.CommandDispatcher;
import com.ssblur.unfocused.Unfocused;
import com.ssblur.unfocused.biome.BiomeModifiers;
import com.ssblur.unfocused.command.CommandRegistration;
import com.ssblur.unfocused.entity.EntityAttributes;
import com.ssblur.unfocused.entity.Trades;
import com.ssblur.unfocused.event.common.EntityDamagedEvent;
import com.ssblur.unfocused.event.common.LootTablePopulateEvent;
import com.ssblur.unfocused.event.common.PlayerChatEvent;
import com.ssblur.unfocused.event.common.PlayerCraftEvent;
import com.ssblur.unfocused.event.common.PlayerJoinedEvent;
import com.ssblur.unfocused.event.common.PlayerTickEvent;
import com.ssblur.unfocused.event.common.ServerStartEvent;
import com.ssblur.unfocused.neoforge.biome.RegistryAwareBiomeModifier;
import com.ssblur.unfocused.neoforge.events.UnfocusedModNetworking;
import com.ssblur.unfocused.registry.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010(\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020'\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010+\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020*\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010.\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020-\u00a2\u0006\u0004\b.\u0010/J\u0015\u00102\u001a\u00020\u00062\u0006\u00101\u001a\u000200\u00a2\u0006\u0004\b2\u00103\u00a8\u00064"}, d2={"Lcom/ssblur/unfocused/neoforge/events/UnfocusedModEvents;", "", "<init>", "()V", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;", "event", "", "livingDamageEventBefore", "(Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;)V", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "livingDamageEventAfter", "(Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;)V", "Lnet/neoforged/neoforge/event/ServerChatEvent;", "chatEvent", "(Lnet/neoforged/neoforge/event/ServerChatEvent;)V", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "playerJoinedEvent", "(Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;)V", "Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Pre;", "playerTickEventBefore", "(Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Pre;)V", "Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Post;", "playerTickEventAfter", "(Lnet/neoforged/neoforge/event/tick/PlayerTickEvent$Post;)V", "Lnet/neoforged/neoforge/event/server/ServerStartedEvent;", "serverLifecycleEvent", "(Lnet/neoforged/neoforge/event/server/ServerStartedEvent;)V", "Lnet/neoforged/neoforge/event/entity/EntityAttributeCreationEvent;", "attributeEvent", "(Lnet/neoforged/neoforge/event/entity/EntityAttributeCreationEvent;)V", "Lnet/neoforged/neoforge/event/LootTableLoadEvent;", "modifyLootTable", "(Lnet/neoforged/neoforge/event/LootTableLoadEvent;)V", "Lnet/neoforged/neoforge/registries/RegisterEvent;", "registerEvent", "(Lnet/neoforged/neoforge/registries/RegisterEvent;)V", "Lnet/neoforged/neoforge/event/village/VillagerTradesEvent;", "tradeRegisterEvent", "(Lnet/neoforged/neoforge/event/village/VillagerTradesEvent;)V", "Lnet/neoforged/neoforge/event/village/WandererTradesEvent;", "wanderingTradesRegisterEvent", "(Lnet/neoforged/neoforge/event/village/WandererTradesEvent;)V", "Lnet/neoforged/neoforge/event/RegisterCommandsEvent;", "commandRegistrationEvent", "(Lnet/neoforged/neoforge/event/RegisterCommandsEvent;)V", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$ItemCraftedEvent;", "itemCraftedEvent", "(Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$ItemCraftedEvent;)V", "Lnet/neoforged/bus/api/IEventBus;", "bus", "register", "(Lnet/neoforged/bus/api/IEventBus;)V", "unfocused-neoforge"})
@SourceDebugExtension(value={"SMAP\nUnfocusedModEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnfocusedModEvents.kt\ncom/ssblur/unfocused/neoforge/events/UnfocusedModEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1869#2,2:165\n*S KotlinDebug\n*F\n+ 1 UnfocusedModEvents.kt\ncom/ssblur/unfocused/neoforge/events/UnfocusedModEvents\n*L\n103#1:165,2\n*E\n"})
public final class UnfocusedModEvents {
    @NotNull
    public static final UnfocusedModEvents INSTANCE = new UnfocusedModEvents();

    private UnfocusedModEvents() {
    }

    public final void livingDamageEventBefore(@NotNull LivingDamageEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EntityDamagedEvent entityDamagedEvent = EntityDamagedEvent.Companion.getBefore();
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        entityDamagedEvent.callback(new EntityDamagedEvent.EntityDamage(livingEntity, damageSource, event.getOriginalDamage(), EntityDamagedEvent.Companion.getBefore()));
        if (EntityDamagedEvent.Companion.getBefore().isCancelled()) {
            Object r = EntityDamagedEvent.Companion.getBefore().getValue();
            Intrinsics.checkNotNull(r);
            event.setNewDamage(((Number)r).floatValue());
        }
    }

    public final void livingDamageEventAfter(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EntityDamagedEvent entityDamagedEvent = EntityDamagedEvent.Companion.getAfter();
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        entityDamagedEvent.callback(new EntityDamagedEvent.EntityDamage(livingEntity, damageSource, event.getOriginalDamage(), EntityDamagedEvent.Companion.getAfter()));
    }

    public final void chatEvent(@NotNull ServerChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PlayerChatEvent playerChatEvent = PlayerChatEvent.Companion.getBefore();
        ServerPlayer serverPlayer = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        Component component = event.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getMessage(...)");
        playerChatEvent.callback(new PlayerChatEvent.PlayerChatMessage(serverPlayer, component, PlayerChatEvent.Companion.getBefore()));
        if (PlayerChatEvent.Companion.getBefore().isCancelled()) {
            event.setCanceled(true);
        }
        PlayerChatEvent playerChatEvent2 = PlayerChatEvent.Companion.getAfter();
        ServerPlayer serverPlayer2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer2, (String)"getPlayer(...)");
        Component component2 = event.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getMessage(...)");
        playerChatEvent2.callback(new PlayerChatEvent.PlayerChatMessage(serverPlayer2, component2, PlayerChatEvent.Companion.getAfter()));
    }

    public final void playerJoinedEvent(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getEntity().level().isClientSide) {
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            PlayerJoinedEvent.INSTANCE.callback((ServerPlayer)player);
        }
    }

    public final void playerTickEventBefore(@NotNull PlayerTickEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof ServerPlayer) {
            PlayerTickEvent playerTickEvent = PlayerTickEvent.Companion.getBefore();
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            playerTickEvent.callback((ServerPlayer)player);
        }
    }

    public final void playerTickEventAfter(@NotNull PlayerTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof ServerPlayer) {
            PlayerTickEvent playerTickEvent = PlayerTickEvent.Companion.getAfter();
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            playerTickEvent.callback((ServerPlayer)player);
        }
    }

    public final void serverLifecycleEvent(@NotNull ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        ServerStartEvent.INSTANCE.callback(minecraftServer);
    }

    public final void attributeEvent(@NotNull EntityAttributeCreationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EntityAttributes.INSTANCE.register(arg_0 -> UnfocusedModEvents.attributeEvent$lambda$0(event, arg_0));
    }

    public final void modifyLootTable(@NotNull LootTableLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List pools = new ArrayList();
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)event.getName());
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        LootTablePopulateEvent.INSTANCE.callback(new LootTablePopulateEvent.LootTableContext((ResourceKey<LootTable>)resourceKey, true, pools));
        Iterable $this$forEach$iv = pools;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LootPool.Builder it = (LootPool.Builder)element$iv;
            boolean bl = false;
            event.getTable().addPool(it.build());
        }
    }

    public final void registerEvent(@NotNull RegisterEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register(NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, UnfocusedModEvents::registerEvent$lambda$2);
    }

    public final void tradeRegisterEvent(@NotNull VillagerTradesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Trades.INSTANCE.register(arg_0 -> UnfocusedModEvents.tradeRegisterEvent$lambda$4(event, arg_0));
    }

    public final void wanderingTradesRegisterEvent(@NotNull WandererTradesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Trades.INSTANCE.register(arg_0 -> UnfocusedModEvents.wanderingTradesRegisterEvent$lambda$5(event, arg_0));
    }

    public final void commandRegistrationEvent(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommandRegistration.INSTANCE.register(arg_0 -> UnfocusedModEvents.commandRegistrationEvent$lambda$6(event, arg_0));
    }

    public final void itemCraftedEvent(@NotNull PlayerEvent.ItemCraftedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        ItemStack itemStack = event.getCrafting();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getCrafting(...)");
        Container container = event.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getInventory(...)");
        PlayerCraftEvent.INSTANCE.callback(new PlayerCraftEvent.PlayerCraftData(player, itemStack, container));
    }

    public final void register(@NotNull IEventBus bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        NeoForge.EVENT_BUS.addListener(this::livingDamageEventBefore);
        NeoForge.EVENT_BUS.addListener(this::livingDamageEventAfter);
        NeoForge.EVENT_BUS.addListener(this::chatEvent);
        NeoForge.EVENT_BUS.addListener(this::playerJoinedEvent);
        NeoForge.EVENT_BUS.addListener(this::playerTickEventBefore);
        NeoForge.EVENT_BUS.addListener(this::playerTickEventAfter);
        NeoForge.EVENT_BUS.addListener(this::serverLifecycleEvent);
        NeoForge.EVENT_BUS.addListener(this::modifyLootTable);
        NeoForge.EVENT_BUS.addListener(this::tradeRegisterEvent);
        NeoForge.EVENT_BUS.addListener(this::wanderingTradesRegisterEvent);
        NeoForge.EVENT_BUS.addListener(this::commandRegistrationEvent);
        NeoForge.EVENT_BUS.addListener(this::itemCraftedEvent);
        BiomeModifiers.INSTANCE.getFeatureEvent().register(UnfocusedModEvents::register$lambda$7);
        bus.addListener(EventPriority.LOWEST, this::registerEvent);
        bus.addListener(this::attributeEvent);
        bus.register((Object)UnfocusedModNetworking.INSTANCE);
    }

    private static final void attributeEvent$lambda$0(EntityAttributeCreationEvent $event, EntityAttributes.EntityTypeAndAttributes entityTypeAndAttributes) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)entityTypeAndAttributes, (String)"<destruct>");
        RegistrySupplier type = entityTypeAndAttributes.component1();
        Supplier<AttributeSupplier.Builder> builder = entityTypeAndAttributes.component2();
        $event.put(type.get(), builder.get().build());
    }

    private static final void registerEvent$lambda$2(RegisterEvent.RegisterHelper register) {
        register.register(Unfocused.INSTANCE.location("features"), RegistryAwareBiomeModifier.Companion.getCODEC());
    }

    private static final NonNullList tradeRegisterEvent$lambda$4$lambda$3(int it) {
        return NonNullList.create();
    }

    private static final void tradeRegisterEvent$lambda$4(VillagerTradesEvent $event, Trades.Trade trade) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        if (Intrinsics.areEqual((Object)trade.getProfession(), (Object)$event.getType())) {
            ((List)$event.getTrades().computeIfAbsent(trade.getRarity(), UnfocusedModEvents::tradeRegisterEvent$lambda$4$lambda$3)).add(trade.getTrade());
        }
    }

    private static final void wanderingTradesRegisterEvent$lambda$5(WandererTradesEvent $event, Trades.Trade trade) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        boolean bl = trade.getRarity() > 0 ? $event.getRareTrades().add(trade.getTrade()) : $event.getGenericTrades().add(trade.getTrade());
    }

    private static final void commandRegistrationEvent$lambda$6(RegisterCommandsEvent $event, CommandRegistration.CommandRegistrationCallback it) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommandDispatcher commandDispatcher = $event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        CommandBuildContext commandBuildContext = $event.getBuildContext();
        Intrinsics.checkNotNullExpressionValue((Object)commandBuildContext, (String)"getBuildContext(...)");
        Commands.CommandSelection commandSelection = $event.getCommandSelection();
        Intrinsics.checkNotNullExpressionValue((Object)commandSelection, (String)"getCommandSelection(...)");
        it.callback((CommandDispatcher<CommandSourceStack>)commandDispatcher, commandBuildContext, commandSelection);
    }

    private static final void register$lambda$7(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println(((BiomeModifiers.BiomeFeature)it.getSecond()).getFeature());
    }
}

