/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.unfocused.helper;

import com.ssblur.unfocused.UtilityExpectPlatform;
import com.ssblur.unfocused.helper.ColorHelper;
import com.ssblur.unfocused.registry.RegistrySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\n\u001a\r\u0012\t\u0012\u00078\u0000\u00a2\u0006\u0002\b\t0\b\"\u0004\b\u0000\u0010\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ5\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u001e\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e\"\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J5\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00152\u001e\u0010\u0017\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00160\u000f0\u000e\"\b\u0012\u0004\u0012\u00020\u00160\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0018J\u001f\u0010\u0013\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u001bJ\u001f\u0010\u0013\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\r\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0013\u0010\u001cJ\u0019\u0010\u0013\u001a\u00020\u0012*\u00020\u001a2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u001dJ\u0019\u0010\u0013\u001a\u00020\u0012*\u00020\u00162\u0006\u0010\r\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0013\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/ssblur/unfocused/helper/ColorHelper;", "", "<init>", "()V", "T", "Ljava/util/function/Function;", "Lcom/ssblur/unfocused/helper/ColorHelper$ColorHolder;", "handler", "", "Lkotlin/jvm/internal/EnhancedNullability;", "forEachColor", "(Ljava/util/function/Function;)Ljava/util/List;", "Lnet/minecraft/client/color/item/ItemColor;", "color", "", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/level/ItemLike;", "items", "", "registerColor", "(Lnet/minecraft/client/color/item/ItemColor;[Ljava/util/function/Supplier;)V", "Lnet/minecraft/client/color/block/BlockColor;", "Lnet/minecraft/world/level/block/Block;", "blocks", "(Lnet/minecraft/client/color/block/BlockColor;[Ljava/util/function/Supplier;)V", "Lcom/ssblur/unfocused/registry/RegistrySupplier;", "Lnet/minecraft/world/item/Item;", "(Lcom/ssblur/unfocused/registry/RegistrySupplier;Lnet/minecraft/client/color/item/ItemColor;)V", "(Lcom/ssblur/unfocused/registry/RegistrySupplier;Lnet/minecraft/client/color/block/BlockColor;)V", "(Lnet/minecraft/world/item/Item;Lnet/minecraft/client/color/item/ItemColor;)V", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/client/color/block/BlockColor;)V", "ColorHolder", "unfocused-common"})
@SourceDebugExtension(value={"SMAP\nColorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorHelper.kt\ncom/ssblur/unfocused/helper/ColorHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1557#2:48\n1628#2,3:49\n*S KotlinDebug\n*F\n+ 1 ColorHelper.kt\ncom/ssblur/unfocused/helper/ColorHelper\n*L\n33#1:48\n33#1:49,3\n*E\n"})
public final class ColorHelper {
    @NotNull
    public static final ColorHelper INSTANCE = new ColorHelper();

    private ColorHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> forEachColor(@NotNull Function<ColorHolder, T> handler) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Iterable $this$map$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DyeColor dyeColor = (DyeColor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(handler.apply(new ColorHolder((DyeColor)it)));
        }
        return (List)destination$iv$iv;
    }

    public final void registerColor(@NotNull ItemColor color, Supplier<ItemLike> ... items) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        UtilityExpectPlatform.registerColor(color, Arrays.copyOf(items, items.length));
    }

    public final void registerColor(@NotNull BlockColor color, Supplier<Block> ... blocks) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        UtilityExpectPlatform.registerColor(color, Arrays.copyOf(blocks, blocks.length));
    }

    public final void registerColor(@NotNull RegistrySupplier<Item> $this$registerColor, @NotNull ItemColor color) {
        Intrinsics.checkNotNullParameter($this$registerColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Supplier[] supplierArray = new Supplier[]{$this$registerColor};
        this.registerColor(color, supplierArray);
    }

    public final void registerColor(@NotNull RegistrySupplier<Block> $this$registerColor, @NotNull BlockColor color) {
        Intrinsics.checkNotNullParameter($this$registerColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Supplier[] supplierArray = new Supplier[]{$this$registerColor};
        this.registerColor(color, supplierArray);
    }

    public final void registerColor(@NotNull Item $this$registerColor, @NotNull ItemColor color) {
        Intrinsics.checkNotNullParameter((Object)$this$registerColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Supplier[] supplierArray = new Supplier[]{() -> ColorHelper.registerColor$lambda$1($this$registerColor)};
        this.registerColor(color, supplierArray);
    }

    public final void registerColor(@NotNull Block $this$registerColor, @NotNull BlockColor color) {
        Intrinsics.checkNotNullParameter((Object)$this$registerColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Supplier[] supplierArray = new Supplier[]{() -> ColorHelper.registerColor$lambda$2($this$registerColor)};
        this.registerColor(color, supplierArray);
    }

    private static final ItemLike registerColor$lambda$1(Item $this_registerColor) {
        Intrinsics.checkNotNullParameter((Object)$this_registerColor, (String)"$this_registerColor");
        return (ItemLike)$this_registerColor;
    }

    private static final Block registerColor$lambda$2(Block $this_registerColor) {
        Intrinsics.checkNotNullParameter((Object)$this_registerColor, (String)"$this_registerColor");
        return $this_registerColor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007R\u0017\u0010\u0016\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0013R\u0012\u0010\u001a\u001a\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u0012\u0010\u001c\u001a\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0012\u0010\u001e\u001a\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u0012\u0010 \u001a\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0012\u0010\"\u001a\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/ssblur/unfocused/helper/ColorHelper$ColorHolder;", "", "Lnet/minecraft/world/item/DyeColor;", "dyeColor", "<init>", "(Lnet/minecraft/world/item/DyeColor;)V", "component1", "()Lnet/minecraft/world/item/DyeColor;", "copy", "(Lnet/minecraft/world/item/DyeColor;)Lcom/ssblur/unfocused/helper/ColorHelper$ColorHolder;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/world/item/DyeColor;", "getDyeColor", "colorName", "Ljava/lang/String;", "getColorName", "getNameAllCaps", "nameAllCaps", "getNameAllLowerCase", "nameAllLowerCase", "getNameTitleCase", "nameTitleCase", "getFireworksColor", "fireworksColor", "getTextColor", "textColor", "unfocused-common"})
    public static final class ColorHolder {
        @NotNull
        private final DyeColor dyeColor;
        @NotNull
        private final String colorName;

        public ColorHolder(@NotNull DyeColor dyeColor) {
            Intrinsics.checkNotNullParameter((Object)dyeColor, (String)"dyeColor");
            this.dyeColor = dyeColor;
            this.colorName = this.dyeColor.name();
        }

        @NotNull
        public final DyeColor getDyeColor() {
            return this.dyeColor;
        }

        @NotNull
        public final String getColorName() {
            return this.colorName;
        }

        @NotNull
        public final String getNameAllCaps() {
            boolean $i$f$getNameAllCaps = false;
            String string = this.getColorName().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return string;
        }

        @NotNull
        public final String getNameAllLowerCase() {
            boolean $i$f$getNameAllLowerCase = false;
            String string = this.getColorName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        @NotNull
        public final String getNameTitleCase() {
            boolean $i$f$getNameTitleCase = false;
            return new Regex("_[a-z]").replace((CharSequence)this.getColorName(), (Function1)nameTitleCase.1.INSTANCE);
        }

        public final int getFireworksColor() {
            boolean $i$f$getFireworksColor = false;
            return this.getDyeColor().getFireworkColor();
        }

        public final int getTextColor() {
            boolean $i$f$getTextColor = false;
            return this.getDyeColor().getTextColor();
        }

        @NotNull
        public final DyeColor component1() {
            return this.dyeColor;
        }

        @NotNull
        public final ColorHolder copy(@NotNull DyeColor dyeColor) {
            Intrinsics.checkNotNullParameter((Object)dyeColor, (String)"dyeColor");
            return new ColorHolder(dyeColor);
        }

        public static /* synthetic */ ColorHolder copy$default(ColorHolder colorHolder, DyeColor dyeColor, int n, Object object) {
            if ((n & 1) != 0) {
                dyeColor = colorHolder.dyeColor;
            }
            return colorHolder.copy(dyeColor);
        }

        @NotNull
        public String toString() {
            return "ColorHolder(dyeColor=" + this.dyeColor + ")";
        }

        public int hashCode() {
            return this.dyeColor.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorHolder)) {
                return false;
            }
            ColorHolder colorHolder = (ColorHolder)other;
            return this.dyeColor == colorHolder.dyeColor;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DyeColor> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])DyeColor.values()));
        }
    }
}

