/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.unfocused.config;

import com.ssblur.unfocused.UtilityExpectPlatform;
import com.ssblur.unfocused.event.common.ServerStartEvent;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ1\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0010\"\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u0012J\r\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR&\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001e0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001dR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\"\u00a8\u0006$"}, d2={"Lcom/ssblur/unfocused/config/Config;", "", "", "id", "delimeter", "topComment", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "key", "value", "", "set", "(Ljava/lang/String;Ljava/lang/String;)V", "get", "(Ljava/lang/String;)Ljava/lang/String;", "default", "", "comment", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "save", "()V", "load", "Ljava/lang/String;", "getId", "()Ljava/lang/String;", "getDelimeter", "getTopComment", "", "values", "Ljava/util/Map;", "", "comments", "", "dirty", "Z", "loaded", "unfocused-common"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\ncom/ssblur/unfocused/config/Config\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class Config {
    @NotNull
    private final String id;
    @NotNull
    private final String delimeter;
    @Nullable
    private final String topComment;
    @NotNull
    private final Map<String, String> values;
    @NotNull
    private final Map<String, List<String>> comments;
    private boolean dirty;
    private boolean loaded;

    public Config(@NotNull String id, @NotNull String delimeter, @Nullable String topComment) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)delimeter, (String)"delimeter");
        this.id = id;
        this.delimeter = delimeter;
        this.topComment = topComment;
        ServerStartEvent.INSTANCE.register(arg_0 -> Config._init_$lambda$1(this, arg_0));
        this.values = new LinkedHashMap();
        this.comments = new LinkedHashMap();
    }

    public /* synthetic */ Config(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "=";
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getDelimeter() {
        return this.delimeter;
    }

    @Nullable
    public final String getTopComment() {
        return this.topComment;
    }

    public final void set(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.loaded) {
            this.load();
        }
        this.values.put(key, value);
        this.dirty = true;
    }

    @Nullable
    public final String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.values.get(key);
    }

    @NotNull
    public final String get(@NotNull String key, @NotNull String string, String ... comment) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)string, (String)"default");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        if (!this.loaded) {
            this.load();
        }
        if (this.values.get(key) == null) {
            this.set(key, string);
            if (comment.length == 0) {
                this.comments.put(key, CollectionsKt.listOf((Object)("Default value for '" + this.id + ":" + key + "' gamerule")));
            } else {
                this.comments.put(key, ArraysKt.toList((Object[])comment));
            }
        }
        String string2 = this.values.get(key);
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    public final void save() {
        if (!this.loaded) {
            this.load();
        }
        this.dirty = false;
        Path dir = UtilityExpectPlatform.configDir();
        Path file = dir.resolve(this.id + ".cfg");
        Intrinsics.checkNotNull((Object)file);
        Path path = file;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        Charset charset2 = charset;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset2);
        if (this.topComment == null) {
            writer.write("## Config file for " + this.id + "\n");
            writer.write("## These are default values for gamerules.\n");
            writer.write("## If your world has already been created, you can change most of them\n");
            writer.write("## using '/gamerule " + this.id + ":[var]'\n\n\n");
        } else {
            writer.write(this.topComment);
        }
        for (Map.Entry entry : this.values.entrySet()) {
            List list = this.comments.get(entry.getKey());
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (String comment : list) {
                writer.write("## " + comment + "\n");
            }
            writer.write((String)entry.getKey());
            writer.write(this.delimeter);
            writer.write(StringsKt.replace$default((String)((String)entry.getValue()), (String)"\n", (String)"\n  ", (boolean)false, (int)4, null));
            writer.write("\n");
        }
        writer.close();
    }

    public final void load() {
        if (this.loaded) {
            return;
        }
        this.dirty = false;
        Path dir = UtilityExpectPlatform.configDir();
        Path file = dir.resolve(this.id + ".cfg");
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.loaded = true;
            this.save();
            return;
        }
        Path path = file;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        Charset charset2 = charset;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset2);
        Ref.ObjectRef value = new Ref.ObjectRef();
        value.element = "";
        Ref.ObjectRef key = new Ref.ObjectRef();
        key.element = "";
        Ref.ObjectRef comment = new Ref.ObjectRef();
        comment.element = new ArrayList();
        Ref.BooleanRef first = new Ref.BooleanRef();
        first.element = true;
        TextStreamsKt.forEachLine((Reader)reader, arg_0 -> Config.load$lambda$3(comment, key, this, value, first, arg_0));
        if (((CharSequence)key.element).length() > 0) {
            this.values.put((String)key.element, (String)value.element);
            this.comments.put((String)key.element, (List<String>)comment.element);
        }
        this.loaded = true;
    }

    private static final void lambda$1$lambda$0(Config this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.dirty) {
            this$0.save();
        }
    }

    private static final void _init_$lambda$1(Config this$0, MinecraftServer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addTickable(() -> Config.lambda$1$lambda$0(this$0));
    }

    private static final Unit load$lambda$3(Ref.ObjectRef $comment, Ref.ObjectRef $key, Config this$0, Ref.ObjectRef $value, Ref.BooleanRef $first, String it) {
        Intrinsics.checkNotNullParameter((Object)$comment, (String)"$comment");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$first, (String)"$first");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (StringsKt.startsWith$default((String)it, (String)"##", (boolean)false, (int)2, null)) {
            Collection collection = (Collection)$comment.element;
            String string = it.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(((Object)StringsKt.trimStart((CharSequence)string)).toString());
        }
        if (new Regex("^\\s+(.*)").matches((CharSequence)it)) {
            MatchResult matchResult = Regex.find$default((Regex)new Regex("^\\s+(.*)"), (CharSequence)it, (int)0, (int)2, null);
            if (matchResult != null) {
                MatchResult match = matchResult;
                boolean bl = false;
                MatchGroup matchGroup = match.getGroups().get(1);
                $value.element = $value.element + (matchGroup != null ? matchGroup.getValue() : null) + "\n";
            }
        } else {
            int n;
            CharSequence charSequence;
            Regex regex;
            List split;
            if (((CharSequence)$key.element).length() > 0) {
                this$0.values.put((String)$key.element, (String)$value.element);
                if (!$first.element) {
                    this$0.comments.put((String)$key.element, (List<String>)$comment.element);
                }
                $comment.element = new ArrayList();
                $first.element = false;
            }
            if ((split = (regex = new Regex(this$0.delimeter)).split(charSequence = (CharSequence)it, n = 2)).size() >= 2) {
                $key.element = ((Object)StringsKt.trim((CharSequence)((String)split.get(0)))).toString();
                $value.element = ((Object)StringsKt.trim((CharSequence)((String)split.get(1)))).toString();
            } else {
                ((Collection)$comment.element).add("");
            }
        }
        return Unit.INSTANCE;
    }
}

