/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.unfocused.biome;

import com.ssblur.unfocused.Unfocused;
import com.ssblur.unfocused.data.DataLoaderRegistry;
import com.ssblur.unfocused.event.LoadEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R)\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR)\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\u000e\u0010\u000bR)\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/ssblur/unfocused/biome/BiomeModifiers;", "", "<init>", "()V", "Lcom/ssblur/unfocused/event/LoadEvent;", "Lkotlin/Pair;", "Lnet/minecraft/resources/ResourceLocation;", "Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeFeature;", "featureEvent", "Lcom/ssblur/unfocused/event/LoadEvent;", "getFeatureEvent", "()Lcom/ssblur/unfocused/event/LoadEvent;", "Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeCarver;", "carverEvent", "getCarverEvent", "Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeSpawner;", "spawnEvent", "getSpawnEvent", "BiomeFeature", "BiomeCarver", "BiomeSpawner", "BiomeModifier", "Spawner", "unfocused-common"})
public final class BiomeModifiers {
    @NotNull
    public static final BiomeModifiers INSTANCE = new BiomeModifiers();
    @NotNull
    private static final LoadEvent<Pair<ResourceLocation, BiomeFeature>> featureEvent = new LoadEvent(false, 1, null);
    @NotNull
    private static final LoadEvent<Pair<ResourceLocation, BiomeCarver>> carverEvent = new LoadEvent(false, 1, null);
    @NotNull
    private static final LoadEvent<Pair<ResourceLocation, BiomeSpawner>> spawnEvent = new LoadEvent(false, 1, null);

    private BiomeModifiers() {
    }

    @NotNull
    public final LoadEvent<Pair<ResourceLocation, BiomeFeature>> getFeatureEvent() {
        return featureEvent;
    }

    @NotNull
    public final LoadEvent<Pair<ResourceLocation, BiomeCarver>> getCarverEvent() {
        return carverEvent;
    }

    @NotNull
    public final LoadEvent<Pair<ResourceLocation, BiomeSpawner>> getSpawnEvent() {
        return spawnEvent;
    }

    private static final void _init_$lambda$0(BiomeFeature modification, ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        featureEvent.callback((Pair<ResourceLocation, BiomeFeature>)new Pair((Object)location, (Object)modification));
    }

    private static final void _init_$lambda$1(BiomeCarver modification, ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        carverEvent.callback((Pair<ResourceLocation, BiomeCarver>)new Pair((Object)location, (Object)modification));
    }

    private static final void _init_$lambda$2(BiomeSpawner modification, ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        spawnEvent.callback((Pair<ResourceLocation, BiomeSpawner>)new Pair((Object)location, (Object)modification));
    }

    static {
        DataLoaderRegistry.registerDataLoader$default(DataLoaderRegistry.INSTANCE, Unfocused.INSTANCE, "unfocused/features", Reflection.getOrCreateKotlinClass(BiomeFeature.class), false, BiomeModifiers::_init_$lambda$0, 4, null);
        DataLoaderRegistry.registerDataLoader$default(DataLoaderRegistry.INSTANCE, Unfocused.INSTANCE, "unfocused/carvers", Reflection.getOrCreateKotlinClass(BiomeCarver.class), false, BiomeModifiers::_init_$lambda$1, 4, null);
        DataLoaderRegistry.registerDataLoader$default(DataLoaderRegistry.INSTANCE, Unfocused.INSTANCE, "unfocused/spawns", Reflection.getOrCreateKotlinClass(BiomeSpawner.class), false, BiomeModifiers::_init_$lambda$2, 4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeCarver;", "Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeModifier;", "", "biome", "Lnet/minecraft/world/level/levelgen/GenerationStep$Carving;", "step", "Lnet/minecraft/resources/ResourceLocation;", "carver", "<init>", "(Ljava/lang/String;Lnet/minecraft/world/level/levelgen/GenerationStep$Carving;Lnet/minecraft/resources/ResourceLocation;)V", "Ljava/lang/String;", "getBiome", "()Ljava/lang/String;", "Lnet/minecraft/world/level/levelgen/GenerationStep$Carving;", "getStep", "()Lnet/minecraft/world/level/levelgen/GenerationStep$Carving;", "Lnet/minecraft/resources/ResourceLocation;", "getCarver", "()Lnet/minecraft/resources/ResourceLocation;", "unfocused-common"})
    public static final class BiomeCarver
    extends BiomeModifier {
        @NotNull
        private final String biome;
        @NotNull
        private final GenerationStep.Carving step;
        @NotNull
        private final ResourceLocation carver;

        public BiomeCarver(@NotNull String biome, @NotNull GenerationStep.Carving step, @NotNull ResourceLocation carver) {
            Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
            Intrinsics.checkNotNullParameter((Object)step, (String)"step");
            Intrinsics.checkNotNullParameter((Object)carver, (String)"carver");
            this.biome = biome;
            this.step = step;
            this.carver = carver;
        }

        @Override
        @NotNull
        public String getBiome() {
            return this.biome;
        }

        @NotNull
        public final GenerationStep.Carving getStep() {
            return this.step;
        }

        @NotNull
        public final ResourceLocation getCarver() {
            return this.carver;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeFeature;", "Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeModifier;", "", "biome", "Lnet/minecraft/world/level/levelgen/GenerationStep$Decoration;", "step", "Lnet/minecraft/resources/ResourceLocation;", "feature", "<init>", "(Ljava/lang/String;Lnet/minecraft/world/level/levelgen/GenerationStep$Decoration;Lnet/minecraft/resources/ResourceLocation;)V", "Ljava/lang/String;", "getBiome", "()Ljava/lang/String;", "Lnet/minecraft/world/level/levelgen/GenerationStep$Decoration;", "getStep", "()Lnet/minecraft/world/level/levelgen/GenerationStep$Decoration;", "Lnet/minecraft/resources/ResourceLocation;", "getFeature", "()Lnet/minecraft/resources/ResourceLocation;", "unfocused-common"})
    public static final class BiomeFeature
    extends BiomeModifier {
        @NotNull
        private final String biome;
        @NotNull
        private final GenerationStep.Decoration step;
        @NotNull
        private final ResourceLocation feature;

        public BiomeFeature(@NotNull String biome, @NotNull GenerationStep.Decoration step, @NotNull ResourceLocation feature) {
            Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
            Intrinsics.checkNotNullParameter((Object)step, (String)"step");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            this.biome = biome;
            this.step = step;
            this.feature = feature;
        }

        @Override
        @NotNull
        public String getBiome() {
            return this.biome;
        }

        @NotNull
        public final GenerationStep.Decoration getStep() {
            return this.step;
        }

        @NotNull
        public final ResourceLocation getFeature() {
            return this.feature;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\r\u001a\u00020\n8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeModifier;", "", "<init>", "()V", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "holder", "", "isValid", "(Lnet/minecraft/core/Holder;)Z", "", "getBiome", "()Ljava/lang/String;", "biome", "unfocused-common"})
    public static abstract class BiomeModifier {
        @NotNull
        public abstract String getBiome();

        public final boolean isValid(@NotNull Holder<Biome> holder) {
            boolean bl;
            Intrinsics.checkNotNullParameter(holder, (String)"holder");
            if (StringsKt.startsWith$default((String)this.getBiome(), (String)"#", (boolean)false, (int)2, null)) {
                String string = this.getBiome().substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                bl = holder.is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)string)));
            } else {
                bl = holder.is(ResourceLocation.parse((String)this.getBiome()));
            }
            return bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeSpawner;", "Lcom/ssblur/unfocused/biome/BiomeModifiers$BiomeModifier;", "", "biome", "", "Lcom/ssblur/unfocused/biome/BiomeModifiers$Spawner;", "spawners", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "Ljava/lang/String;", "getBiome", "()Ljava/lang/String;", "Ljava/util/List;", "getSpawners", "()Ljava/util/List;", "unfocused-common"})
    public static final class BiomeSpawner
    extends BiomeModifier {
        @NotNull
        private final String biome;
        @NotNull
        private final List<Spawner> spawners;

        public BiomeSpawner(@NotNull String biome, @NotNull List<Spawner> spawners) {
            Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
            Intrinsics.checkNotNullParameter(spawners, (String)"spawners");
            this.biome = biome;
            this.spawners = spawners;
        }

        @Override
        @NotNull
        public String getBiome() {
            return this.biome;
        }

        @NotNull
        public final List<Spawner> getSpawners() {
            return this.spawners;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013JB\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u000fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010 \u001a\u0004\b\"\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b#\u0010\u000fR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010$\u001a\u0004\b%\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/ssblur/unfocused/biome/BiomeModifiers$Spawner;", "", "Lnet/minecraft/resources/ResourceLocation;", "type", "", "weight", "minCount", "maxCount", "Lnet/minecraft/world/entity/MobCategory;", "category", "<init>", "(Lnet/minecraft/resources/ResourceLocation;IIILnet/minecraft/world/entity/MobCategory;)V", "component1", "()Lnet/minecraft/resources/ResourceLocation;", "component2", "()I", "component3", "component4", "component5", "()Lnet/minecraft/world/entity/MobCategory;", "copy", "(Lnet/minecraft/resources/ResourceLocation;IIILnet/minecraft/world/entity/MobCategory;)Lcom/ssblur/unfocused/biome/BiomeModifiers$Spawner;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/resources/ResourceLocation;", "getType", "I", "getWeight", "getMinCount", "getMaxCount", "Lnet/minecraft/world/entity/MobCategory;", "getCategory", "unfocused-common"})
    public static final class Spawner {
        @NotNull
        private final ResourceLocation type;
        private final int weight;
        private final int minCount;
        private final int maxCount;
        @NotNull
        private final MobCategory category;

        public Spawner(@NotNull ResourceLocation type, int weight, int minCount, int maxCount, @NotNull MobCategory category) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            this.type = type;
            this.weight = weight;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.category = category;
        }

        @NotNull
        public final ResourceLocation getType() {
            return this.type;
        }

        public final int getWeight() {
            return this.weight;
        }

        public final int getMinCount() {
            return this.minCount;
        }

        public final int getMaxCount() {
            return this.maxCount;
        }

        @NotNull
        public final MobCategory getCategory() {
            return this.category;
        }

        @NotNull
        public final ResourceLocation component1() {
            return this.type;
        }

        public final int component2() {
            return this.weight;
        }

        public final int component3() {
            return this.minCount;
        }

        public final int component4() {
            return this.maxCount;
        }

        @NotNull
        public final MobCategory component5() {
            return this.category;
        }

        @NotNull
        public final Spawner copy(@NotNull ResourceLocation type, int weight, int minCount, int maxCount, @NotNull MobCategory category) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            return new Spawner(type, weight, minCount, maxCount, category);
        }

        public static /* synthetic */ Spawner copy$default(Spawner spawner, ResourceLocation resourceLocation, int n, int n2, int n3, MobCategory mobCategory, int n4, Object object) {
            if ((n4 & 1) != 0) {
                resourceLocation = spawner.type;
            }
            if ((n4 & 2) != 0) {
                n = spawner.weight;
            }
            if ((n4 & 4) != 0) {
                n2 = spawner.minCount;
            }
            if ((n4 & 8) != 0) {
                n3 = spawner.maxCount;
            }
            if ((n4 & 0x10) != 0) {
                mobCategory = spawner.category;
            }
            return spawner.copy(resourceLocation, n, n2, n3, mobCategory);
        }

        @NotNull
        public String toString() {
            return "Spawner(type=" + this.type + ", weight=" + this.weight + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + ", category=" + this.category + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.weight);
            result = result * 31 + Integer.hashCode(this.minCount);
            result = result * 31 + Integer.hashCode(this.maxCount);
            result = result * 31 + this.category.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spawner)) {
                return false;
            }
            Spawner spawner = (Spawner)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)spawner.type)) {
                return false;
            }
            if (this.weight != spawner.weight) {
                return false;
            }
            if (this.minCount != spawner.minCount) {
                return false;
            }
            if (this.maxCount != spawner.maxCount) {
                return false;
            }
            return this.category == spawner.category;
        }
    }
}

