/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class AdamantiumStaff
extends Item {
    private int selectedPropertyIndex = 0;
    private static final List<String> PROPERTY_NAMES = List.of("facing", "colour", "shape", "waterlogged", "type", "layer", "age", "light");

    public AdamantiumStaff(Item.Properties properties) {
        super(properties);
    }

    public boolean canAttackBlock(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        return false;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState blockState = world.getBlockState(pos);
        if (player == null || world.isClientSide) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            this.cycleSelectedProperty(player);
            return InteractionResult.SUCCESS;
        }
        return this.modifyProperty(player, world, pos, blockState);
    }

    private void cycleSelectedProperty(Player player) {
        this.selectedPropertyIndex = (this.selectedPropertyIndex + 1) % PROPERTY_NAMES.size();
        String selectedProperty = PROPERTY_NAMES.get(this.selectedPropertyIndex);
        player.displayClientMessage((Component)Component.literal((String)("Selected Property: " + selectedProperty.toUpperCase())), true);
    }

    private InteractionResult modifyProperty(Player player, Level world, BlockPos pos, BlockState blockState) {
        String selectedProperty = PROPERTY_NAMES.get(this.selectedPropertyIndex);
        Optional<Property> property = blockState.getProperties().stream().filter(p -> p.getName().equals(selectedProperty)).findFirst();
        if (property.isPresent()) {
            Property prop = property.get();
            BlockState newState = AdamantiumStaff.cycleProperty(blockState, prop);
            world.setBlock(pos, newState, 3);
            player.displayClientMessage((Component)Component.literal((String)(selectedProperty.toUpperCase() + " \u2192 " + newState.getValue(prop).toString())), true);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.literal((String)("This block doesn't support the '" + selectedProperty + "' property.")), true);
        return InteractionResult.SUCCESS;
    }

    private static <T extends Comparable<T>> BlockState cycleProperty(BlockState state, Property<T> property) {
        return (BlockState)state.setValue(property, AdamantiumStaff.getNextValue(property, state.getValue(property)));
    }

    private static <T extends Comparable<T>> T getNextValue(Property<T> property, T currentValue) {
        List values = List.copyOf(property.getPossibleValues());
        int nextIndex = (values.indexOf(currentValue) + 1) % values.size();
        return (T)((Comparable)values.get(nextIndex));
    }
}

