/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ThinVertStairsBlock
extends StairBlock {
    private static final VoxelShape SHAPE_NORTH = ThinVertStairsBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_SOUTH = ThinVertStairsBlock.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = ThinVertStairsBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = ThinVertStairsBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape OUTER_NW = ThinVertStairsBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
    private static final VoxelShape OUTER_NE = ThinVertStairsBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape OUTER_SW = ThinVertStairsBlock.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape OUTER_SE = ThinVertStairsBlock.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public ThinVertStairsBlock(BlockBehaviour.Properties properties) {
        super(Blocks.STONE.defaultBlockState(), properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        if (shape == StairsShape.OUTER_LEFT || shape == StairsShape.OUTER_RIGHT) {
            return switch (facing) {
                case Direction.NORTH -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_NW;
                    }
                    yield OUTER_NE;
                }
                case Direction.SOUTH -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_SE;
                    }
                    yield OUTER_SW;
                }
                case Direction.EAST -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_NE;
                    }
                    yield OUTER_SE;
                }
                case Direction.WEST -> {
                    if (shape == StairsShape.OUTER_LEFT) {
                        yield OUTER_SW;
                    }
                    yield OUTER_NW;
                }
                default -> OUTER_SE;
            };
        }
        return switch (facing) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }
}

