/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ShapeDoorsSide
extends Block {
    public static final IntegerProperty SHAPE = IntegerProperty.create((String)"shape", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)3);
    private static final VoxelShape CLOSED_SOUTH = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)-10.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)4.0), (VoxelShape)ShapeDoorsSide.box((double)8.0, (double)0.0, (double)0.0, (double)26.0, (double)16.0, (double)4.0));
    private static final VoxelShape CLOSED_NORTH = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)-10.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)ShapeDoorsSide.box((double)8.0, (double)0.0, (double)12.0, (double)26.0, (double)16.0, (double)16.0));
    private static final VoxelShape CLOSED_EAST = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)0.0, (double)0.0, (double)-10.0, (double)4.0, (double)16.0, (double)8.0), (VoxelShape)ShapeDoorsSide.box((double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)26.0));
    private static final VoxelShape CLOSED_WEST = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)12.0, (double)0.0, (double)-10.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)ShapeDoorsSide.box((double)12.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)26.0));
    private static final VoxelShape OPEN_NORTH = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)-10.0, (double)0.0, (double)12.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape)ShapeDoorsSide.box((double)14.0, (double)0.0, (double)12.0, (double)26.0, (double)16.0, (double)16.0));
    private static final VoxelShape OPEN_SOUTH = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)-10.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0), (VoxelShape)ShapeDoorsSide.box((double)14.0, (double)0.0, (double)0.0, (double)26.0, (double)16.0, (double)4.0));
    private static final VoxelShape OPEN_EAST = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)0.0, (double)0.0, (double)-10.0, (double)4.0, (double)16.0, (double)2.0), (VoxelShape)ShapeDoorsSide.box((double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0, (double)26.0));
    private static final VoxelShape OPEN_WEST = Shapes.or((VoxelShape)ShapeDoorsSide.box((double)12.0, (double)0.0, (double)-10.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape)ShapeDoorsSide.box((double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)26.0));
    private static final VoxelShape LEFTOPEN_SOUTH = ShapeDoorsSide.box((double)8.0, (double)0.0, (double)0.0, (double)26.0, (double)16.0, (double)4.0);
    private static final VoxelShape LEFTOPEN_NORTH = ShapeDoorsSide.box((double)-10.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape LEFTOPEN_WEST = ShapeDoorsSide.box((double)12.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)26.0);
    private static final VoxelShape LEFTOPEN_EAST = ShapeDoorsSide.box((double)0.0, (double)0.0, (double)-10.0, (double)4.0, (double)16.0, (double)8.0);
    private static final VoxelShape RIGHTOPEN_SOUTH = ShapeDoorsSide.box((double)-10.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)4.0);
    private static final VoxelShape RIGHTOPEN_NORTH = ShapeDoorsSide.box((double)8.0, (double)0.0, (double)12.0, (double)26.0, (double)16.0, (double)16.0);
    private static final VoxelShape RIGHTOPEN_WEST = ShapeDoorsSide.box((double)12.0, (double)0.0, (double)-10.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape RIGHTOPEN_EAST = ShapeDoorsSide.box((double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)26.0);

    public ShapeDoorsSide(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SHAPE, (Comparable)Integer.valueOf(0))).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE, COLOUR});
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)SHAPE, (Comparable)Integer.valueOf(0))).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int shape = (Integer)state.getValue((Property)SHAPE);
        return switch (shape) {
            case 0 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        yield CLOSED_SOUTH;
                    }
                    case EAST: {
                        yield CLOSED_EAST;
                    }
                    case WEST: {
                        yield CLOSED_WEST;
                    }
                }
                yield CLOSED_NORTH;
            }
            case 1 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        yield LEFTOPEN_SOUTH;
                    }
                    case EAST: {
                        yield LEFTOPEN_EAST;
                    }
                    case WEST: {
                        yield LEFTOPEN_WEST;
                    }
                }
                yield LEFTOPEN_NORTH;
            }
            case 2 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        yield RIGHTOPEN_SOUTH;
                    }
                    case EAST: {
                        yield RIGHTOPEN_EAST;
                    }
                    case WEST: {
                        yield RIGHTOPEN_WEST;
                    }
                }
                yield RIGHTOPEN_NORTH;
            }
            case 3 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        yield OPEN_SOUTH;
                    }
                    case EAST: {
                        yield OPEN_EAST;
                    }
                    case WEST: {
                        yield OPEN_WEST;
                    }
                }
                yield OPEN_NORTH;
            }
            default -> Shapes.empty();
        };
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!level.isClientSide && player.isCrouching() && player.isCreative()) {
            int currentShape = (Integer)state.getValue((Property)SHAPE);
            int nextShape = (currentShape + 1) % 4;
            level.setBlock(pos, (BlockState)state.setValue((Property)SHAPE, (Comparable)Integer.valueOf(nextShape)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }
}

