/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RoseWindow
extends Block {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final IntegerProperty INVERTED = IntegerProperty.create((String)"inverted", (int)0, (int)1);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)6);
    private static final VoxelShape SHAPE_N = RoseWindow.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_E = RoseWindow.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_S = RoseWindow.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_W = RoseWindow.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);

    public RoseWindow(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)INVERTED, (Comparable)Integer.valueOf(0))).setValue(TYPE, (Comparable)((Object)Type.BOTTOM)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos = context.getClickedPos();
        Vec3 hitVec = context.getClickLocation();
        Type type = context.getClickedFace() == Direction.DOWN ? Type.TOP : Type.BOTTOM;
        Direction playerFacing = context.getHorizontalDirection();
        double relativeX = hitVec.x - (double)clickedPos.getX();
        double relativeZ = hitVec.z - (double)clickedPos.getZ();
        int sideValue = RoseWindow.getSideValue(playerFacing, relativeX, relativeZ);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)COLOUR, (Comparable)Integer.valueOf(0))).setValue((Property)INVERTED, (Comparable)Integer.valueOf(sideValue))).setValue(TYPE, (Comparable)((Object)type))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)playerFacing.getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    private static int getSideValue(Direction playerFacing, double relativeX, double relativeZ) {
        int sideValue;
        double relativePos;
        double d = relativePos = playerFacing == Direction.NORTH || playerFacing == Direction.SOUTH ? relativeX : relativeZ;
        int n = Math.abs(relativePos) < 0.5 ? 0 : (sideValue = Math.abs(relativePos - 1.0) < 0.5 ? 1 : 0);
        if (playerFacing == Direction.WEST || playerFacing == Direction.NORTH) {
            sideValue = 1 - sideValue;
        }
        if (playerFacing == Direction.EAST || playerFacing == Direction.WEST) {
            sideValue = 1 - sideValue;
        }
        return sideValue;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COLOUR, TYPE, INVERTED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_S;
            case Direction.EAST -> SHAPE_E;
            case Direction.WEST -> SHAPE_W;
            default -> SHAPE_N;
        };
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!level.isClientSide && player.isCrouching() && player.isCreative()) {
            int currentColour = (Integer)state.getValue((Property)COLOUR);
            int newColour = (currentColour + 1) % 6;
            level.setBlock(pos, (BlockState)state.setValue((Property)COLOUR, (Comparable)Integer.valueOf(newColour)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    public static enum Type implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

