/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class HorizQuarterStairBlocks
extends StairBlock {
    private static final VoxelShape SHAPE_S = HorizQuarterStairBlocks.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_W = HorizQuarterStairBlocks.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_N = HorizQuarterStairBlocks.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape SHAPE_E = HorizQuarterStairBlocks.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public HorizQuarterStairBlocks(BlockBehaviour.Properties settings) {
        super(Blocks.OAK_PLANKS.defaultBlockState(), settings);
        this.registerDefaultState(this.defaultBlockState());
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_S;
            case Direction.EAST -> SHAPE_E;
            case Direction.WEST -> SHAPE_W;
            default -> SHAPE_N;
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

