/*
 * Decompiled with CFR 0.152.
 */
package net.velveteen.mythrais.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ArrowLoop
extends Block {
    private static final IntegerProperty COLOUR = IntegerProperty.create((String)"colour", (int)0, (int)6);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)9.0, (double)6.0, (double)32.0, (double)16.0), (VoxelShape)Block.box((double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)32.0, (double)16.0));
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)6.0), (VoxelShape)Block.box((double)9.0, (double)0.0, (double)10.0, (double)16.0, (double)32.0, (double)16.0));
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)7.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)32.0, (double)7.0));
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)32.0, (double)6.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)10.0, (double)7.0, (double)32.0, (double)16.0));

    public ArrowLoop(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)COLOUR, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        boolean isWater = level.getFluidState(pos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)COLOUR, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COLOUR, WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, Level level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, (LevelAccessor)level, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (!level.isClientSide && player.isCrouching() && player.isCreative()) {
            int currentColour = (Integer)state.getValue((Property)COLOUR);
            int newColour = (currentColour + 1) % 7;
            level.setBlock(pos, (BlockState)state.setValue((Property)COLOUR, (Comparable)Integer.valueOf(newColour)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }
}

