/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.datagen.AEAdvancementsProvider;
import alexthw.ars_elemental.datagen.AEApparatusProvider;
import alexthw.ars_elemental.datagen.AEBlockStateProvider;
import alexthw.ars_elemental.datagen.AECasterTomeProvider;
import alexthw.ars_elemental.datagen.AECrushProvider;
import alexthw.ars_elemental.datagen.AECurioProvider;
import alexthw.ars_elemental.datagen.AEDamageTypesProvider;
import alexthw.ars_elemental.datagen.AEEnchantmentProvider;
import alexthw.ars_elemental.datagen.AEGlyphProvider;
import alexthw.ars_elemental.datagen.AEImbuementProvider;
import alexthw.ars_elemental.datagen.AEItemModelProvider;
import alexthw.ars_elemental.datagen.AELangDatagen;
import alexthw.ars_elemental.datagen.AELootTables;
import alexthw.ars_elemental.datagen.AEPatchouliProvider;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.datagen.AEWorldgenProvider;
import alexthw.ars_elemental.datagen.CompostablesProvider;
import alexthw.ars_elemental.datagen.ModRecipeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="ars_elemental", bus=EventBusSubscriber.Bus.MOD)
public class Datagen {
    public static CompletableFuture<HolderLookup.Provider> provider;
    public static PackOutput output;

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        provider = event.getLookupProvider();
        output = gen.getPackOutput();
        gen.addProvider(event.includeClient(), (DataProvider)new AEBlockStateProvider(gen, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new AEItemModelProvider(gen, existingFileHelper));
        AETagsProvider.AEBlockTagsProvider BTP = new AETagsProvider.AEBlockTagsProvider(gen, provider, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)new AEEnchantmentProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AEDamageTypesProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)BTP);
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEMobEffectTagProvider(gen, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEItemTagsProvider(gen, provider, BTP, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEEntityTagProvider(gen, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEDamageTypeProvider(gen, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEBannerTagsProvider(output, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(gen, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AELootTables(gen, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new CompostablesProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AEImbuementProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AEGlyphProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AEApparatusProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AECrushProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AEPatchouliProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AECurioProvider(output, existingFileHelper, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AEAdvancementsProvider(output, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AECasterTomeProvider(gen));
        gen.addProvider(event.includeClient(), (DataProvider)new AELangDatagen(output, "ars_elemental", "en_us"));
        gen.addProvider(event.includeServer(), (DataProvider)new AEWorldgenProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEFeatureTagsProvider(gen, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEBiomeTagsProvider(gen, provider, existingFileHelper));
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> predicate) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!predicate.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }
}

