/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import alexthw.ars_elemental.world.ModWorldgen;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.datagen.BannerTagsProvider;
import com.hollingsworth.arsnouveau.common.datagen.BiomeTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.lib.PotionEffectTags;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AETagsProvider {

    public static class AEBannerTagsProvider
    extends BannerPatternTagsProvider {
        public AEBannerTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, provider, "ars_elemental", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(BannerTagsProvider.bannerTag).addOptional(ArsNouveauRegistry.ANIMA_ICON.location());
        }
    }

    public static class AEDamageTypeProvider
    extends DamageTypeTagsProvider {
        public AEDamageTypeProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pGenerator.getPackOutput(), provider, "ars_elemental", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(Tags.DamageTypes.IS_MAGIC).addOptional(ModRegistry.MAGIC_FIRE.location()).addOptional(ModRegistry.SPARK.location()).addOptional(ModRegistry.CUT.location()).addOptional(ModRegistry.POISON.location());
            this.tag(DamageTypeTags.ALWAYS_HURTS_ENDER_DRAGONS).addOptional(ModRegistry.MAGIC_FIRE.location()).addOptional(ModRegistry.SPARK.location()).addOptional(ModRegistry.CUT.location()).addOptional(ModRegistry.POISON.location());
            this.tag(Tags.DamageTypes.IS_POISON).addOptional(ModRegistry.POISON.location());
            this.tag(ModRegistry.FIRE_DAMAGE).addTag(DamageTypeTags.IS_FIRE).add(new ResourceKey[]{DamageTypes.DRAGON_BREATH, DamageTypes.EXPLOSION, DamageTypes.PLAYER_EXPLOSION, DamageTypes.FIREWORKS}).addOptional(ModRegistry.MAGIC_FIRE.location());
            this.tag(ModRegistry.WATER_DAMAGE).addTag(DamageTypeTags.IS_FREEZING).addTag(DamageTypeTags.IS_DROWNING).add(new ResourceKey[]{DamageTypes.TRIDENT, DamageTypes.MAGIC});
            this.tag(ModRegistry.EARTH_DAMAGE).add(new ResourceKey[]{DamageTypes.FALLING_BLOCK, DamageTypes.FALLING_STALACTITE, DamageTypes.STALAGMITE, DamageTypes.CACTUS, DamageTypes.FALLING_ANVIL, DamageTypes.STING, DamageTypes.SWEET_BERRY_BUSH}).addTag(Tags.DamageTypes.IS_POISON).addOptional(DamageTypesRegistry.CRUSH.location()).addOptional(DamageTypesRegistry.SOURCE_BERRY_BUSH.location());
            this.tag(DamageTypeTags.IS_LIGHTNING).addOptional(ModRegistry.SPARK.location());
            this.tag(ModRegistry.AIR_DAMAGE).addTag(DamageTypeTags.IS_LIGHTNING).add(new ResourceKey[]{DamageTypes.FALL, DamageTypes.FLY_INTO_WALL, DamageTypes.SONIC_BOOM}).addOptional(ModRegistry.CUT.location()).addOptional(DamageTypesRegistry.WINDSHEAR.location());
        }
    }

    public static class AEMobEffectTagProvider
    extends IntrinsicHolderTagsProvider<MobEffect> {
        public static TagKey<MobEffect> BUBBLE_BLACKLIST = TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)ArsElemental.prefix("manabubble_blacklist"));

        public AEMobEffectTagProvider(DataGenerator pOutput, CompletableFuture<HolderLookup.Provider> pProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pOutput.getPackOutput(), Registries.MOB_EFFECT, pProvider, ef -> (ResourceKey)BuiltInRegistries.MOB_EFFECT.getResourceKey(ef).orElseThrow(), "ars_elemental", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(BUBBLE_BLACKLIST).add(new ResourceKey[]{MobEffects.LEVITATION.getKey(), ModPotions.HYMN_OF_ORDER.getKey(), com.hollingsworth.arsnouveau.setup.registry.ModPotions.SUMMONING_SICKNESS_EFFECT.getKey()});
            this.tag(PotionEffectTags.TO_SYNC).add((Object)((MobEffect)ModPotions.MAGIC_FIRE.get()));
        }
    }

    public static class AEEntityTagProvider
    extends EntityTypeTagsProvider {
        public static final TagKey<EntityType<?>> VITALIC_GROWTH_BLACKLIST = EntityTags.VITALIC_GROWTH_BLACKLIST;
        public static final TagKey<EntityType<?>> VITALIC_DEATH_BLACKLIST = EntityTags.VITALIC_DEATH_BLACKLIST;

        public AEEntityTagProvider(DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(pGenerator.getPackOutput(), provider, "ars_elemental", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(EntityTags.MAGIC_FIND).add((Object)((EntityType)ModEntities.SIREN_ENTITY.get()));
            this.tag(EntityTags.MAGIC_FIND).add((Object[])new EntityType[]{(EntityType)ModEntities.AIR_MAGE.get(), (EntityType)ModEntities.FIRE_MAGE.get(), (EntityType)ModEntities.EARTH_MAGE.get(), (EntityType)ModEntities.WATER_MAGE.get()});
            this.tag(EntityTags.FAMILIAR).add((Object[])new EntityType[]{(EntityType)ModEntities.FIRENANDO_FAMILIAR.get(), (EntityType)ModEntities.SIREN_FAMILIAR.get()});
            this.tag(ModRegistry.AERIAL).add((Object[])new EntityType[]{EntityType.PHANTOM, EntityType.WITHER, EntityType.BAT, EntityType.ALLAY, EntityType.ENDER_DRAGON, EntityType.PARROT, EntityType.GHAST, EntityType.VEX, EntityType.BEE, (EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WILDEN_STALKER.get(), (EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.WILDEN_BOSS.get()});
            this.tag(ModRegistry.FIERY).add((Object)EntityType.ENDER_DRAGON);
            this.tag(EntityTypeTags.UNDEAD).add((Object)EntityType.GHAST);
            this.tag(EntityTypeTags.AQUATIC).add((Object[])new EntityType[]{EntityType.AXOLOTL, EntityType.FROG, EntityType.DROWNED});
            this.tag(ModRegistry.INSECT).add((Object)EntityType.SILVERFISH);
            this.tag(ModRegistry.ATTRACT_BLACKLIST).add((Object)EntityType.PLAYER).addTag(Tags.EntityTypes.BOSSES).add((Object)((EntityType)com.hollingsworth.arsnouveau.setup.registry.ModEntities.ENTITY_FOLLOW_PROJ.get())).addTag(EntityTags.FAMILIAR);
            this.tag(EntityTypeTags.UNDEAD).add((Object[])new EntityType[]{(EntityType)ModEntities.SKELEHORSE_SUMMON.get(), (EntityType)ModEntities.WSKELETON_SUMMON.get()});
            this.tag(EntityTypeTags.AQUATIC).add((Object[])new EntityType[]{(EntityType)ModEntities.SIREN_ENTITY.get(), (EntityType)ModEntities.SIREN_FAMILIAR.get()});
            this.tag(EntityTypeTags.CAN_BREATHE_UNDER_WATER).add((Object[])new EntityType[]{(EntityType)ModEntities.SIREN_ENTITY.get(), (EntityType)ModEntities.SIREN_FAMILIAR.get()});
            this.tag(EntityTypeTags.NOT_SCARY_FOR_PUFFERFISH).add((Object[])new EntityType[]{(EntityType)ModEntities.SIREN_ENTITY.get(), (EntityType)ModEntities.SIREN_FAMILIAR.get()});
            this.tag(EntityTypeTags.SKELETONS).add((Object[])new EntityType[]{(EntityType)ModEntities.SKELEHORSE_SUMMON.get(), (EntityType)ModEntities.WSKELETON_SUMMON.get()});
            this.tag(EntityTypeTags.INVERTED_HEALING_AND_HARM).add((Object[])new EntityType[]{(EntityType)ModEntities.SKELEHORSE_SUMMON.get(), (EntityType)ModEntities.WSKELETON_SUMMON.get()});
            this.tag(ModRegistry.CHARM_BLACKLIST);
            this.tag(VITALIC_GROWTH_BLACKLIST).add((Object)((EntityType)ModEntities.FLASHING_WEALD_WALKER.get()));
            this.tag(VITALIC_DEATH_BLACKLIST).add((Object)((EntityType)ModEntities.FLASHING_WEALD_WALKER.get()));
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Entity Tags";
        }
    }

    public static class AEFeatureTagsProvider
    extends TagsProvider<PlacedFeature> {
        public static TagKey<PlacedFeature> RARE_ARCHWOOD_TREES = TagKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ArsElemental.prefix("flashing_archwood"));
        public static TagKey<PlacedFeature> COMMON_ARCHWOOD_TREES = TagKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ArsElemental.prefix("common_flashing_archwood"));

        public AEFeatureTagsProvider(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator.getPackOutput(), Registries.PLACED_FEATURE, provider, "ars_elemental", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(RARE_ARCHWOOD_TREES).addOptional(ModWorldgen.RARE_FLASHING_CONFIGURED.location());
            this.tag(COMMON_ARCHWOOD_TREES).addOptional(ModWorldgen.COMMON_FLASHING_CONFIGURED.location());
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Feature Tags";
        }
    }

    public static class AEBiomeTagsProvider
    extends BiomeTagsProvider {
        public static final TagKey<Biome> SIREN_SPAWN_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsElemental.prefix("siren_spawn"));
        public static final TagKey<Biome> FLASHING_BIOME = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsElemental.prefix("flashing_biome"));
        public static final TagKey<Biome> FLASHING_TREE_COMMON_BIOME = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsElemental.prefix("flashing_tree_biome"));
        public static final TagKey<Biome> HAS_LIBRARY = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_additions", (String)"has_structure/arcane_library"));
        public static final TagKey<Biome> HAS_NEXUS = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_additions", (String)"has_structure/nexus_tower"));

        public AEBiomeTagsProvider(DataGenerator generator, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator.getPackOutput(), provider, "ars_elemental", existingFileHelper);
        }

        static TagKey<Biome> cobblemonBiomeTag(String string) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)string));
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(SIREN_SPAWN_TAG).addTag(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL).addOptionalTag(BiomeTagProvider.ARCHWOOD_BIOME_TAG.location());
            this.tag(FLASHING_BIOME).addOptional(ModWorldgen.Biomes.FLASHING_FOREST_KEY.location());
            this.tag(FLASHING_TREE_COMMON_BIOME).addOptional(BiomeRegistry.ARCHWOOD_FOREST.location());
            this.tag(BiomeTags.IS_MOUNTAIN).addOptional(ModWorldgen.Biomes.FLASHING_FOREST_KEY.location());
            this.tag(Tags.Biomes.IS_MOUNTAIN_PEAK).addOptional(ModWorldgen.Biomes.FLASHING_FOREST_KEY.location());
            this.tag(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL).addOptional(ModWorldgen.Biomes.CASCADING_FOREST_KEY.location());
            this.tag(BiomeTags.IS_BEACH).addOptional(ModWorldgen.Biomes.CASCADING_FOREST_KEY.location());
            this.tag(Tags.Biomes.IS_SWAMP).addOptional(ModWorldgen.Biomes.CASCADING_FOREST_KEY.location());
            this.tag(BiomeTags.HAS_SWAMP_HUT).addOptional(ModWorldgen.Biomes.CASCADING_FOREST_KEY.location());
            this.tag(BiomeTags.IS_JUNGLE).addOptional(ModWorldgen.Biomes.FLOURISHING_FOREST_KEY.location());
            this.tag(BiomeTags.HAS_JUNGLE_TEMPLE).addOptional(ModWorldgen.Biomes.FLOURISHING_FOREST_KEY.location());
            this.tag(Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD).addOptional(ModWorldgen.Biomes.FLOURISHING_FOREST_KEY.location());
            this.tag(BiomeTags.HAS_WOODLAND_MANSION).addTag(BiomeTagProvider.ARCHWOOD_BIOME_TAG);
            this.tag(Tags.Biomes.IS_MAGICAL).addTag(BiomeTagProvider.ARCHWOOD_BIOME_TAG);
            for (ResourceLocation forest : ModWorldgen.Biomes.ArchwoodBiomes) {
                this.tag(BiomeTagProvider.ARCHWOOD_BIOME_TAG).addOptional(forest);
                this.tag(BiomeTagProvider.BERRY_SPAWN).addOptional(forest);
                this.tag(HAS_LIBRARY).addOptional(forest);
                this.tag(HAS_NEXUS).addOptional(forest);
            }
            this.tag(AEBiomeTagsProvider.cobblemonBiomeTag("volcanic")).addOptional(ModWorldgen.Biomes.BLAZING_FOREST_KEY.location());
            this.tag(AEBiomeTagsProvider.cobblemonBiomeTag("frozen")).addOptional(ModWorldgen.Biomes.CASCADING_FOREST_KEY.location());
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Biome Tags";
        }
    }

    public static class AEBlockTagsProvider
    extends BlockTagsProvider {
        final TagKey<Block> ARCHWOOD_LEAVES = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"leaves/archwood_leaves"));
        public static final TagKey<Block> FLASHING_LOGS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)"logs/flashing_archwood"));
        public static final TagKey<Block> AQUARIUM_BONUS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)"aquarium_bonus"));
        public static TagKey<Block> SUMMER_CROPS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)"summer_crops"));

        public AEBlockTagsProvider(DataGenerator gen, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(gen.getPackOutput(), provider, "ars_elemental", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.addPickMineable(1, (Block)ModItems.WATER_UPSTREAM_BLOCK.get(), (Block)ModItems.AIR_UPSTREAM_BLOCK.get(), (Block)ModItems.LAVA_UPSTREAM_BLOCK.get(), (Block)ModItems.MERMAID_ROCK.get());
            this.addPickMineable(0, (Block)ModItems.SPELL_MIRROR.get(), (Block)ModItems.AIR_TURRET.get(), (Block)ModItems.FIRE_TURRET.get(), (Block)ModItems.EARTH_TURRET.get(), (Block)ModItems.WATER_TURRET.get(), (Block)ModItems.SHAPING_TURRET.get(), (Block)ModItems.ADVANCED_PRISM.get());
            this.logsTag((Block)ModItems.FLASHING_ARCHWOOD_LOG.get(), (Block)ModItems.FLASHING_ARCHWOOD.get(), (Block)ModItems.FLASHING_ARCHWOOD_STRIPPED.get(), (Block)ModItems.FLASHING_ARCHWOOD_LOG_STRIPPED.get());
            this.tag(FLASHING_LOGS).add((Object[])new Block[]{(Block)ModItems.FLASHING_ARCHWOOD_LOG.get(), (Block)ModItems.FLASHING_ARCHWOOD.get(), (Block)ModItems.FLASHING_ARCHWOOD_STRIPPED.get(), (Block)ModItems.FLASHING_ARCHWOOD_LOG_STRIPPED.get()});
            this.tag(Tags.Blocks.STRIPPED_LOGS).add((Object)((Block)ModItems.FLASHING_ARCHWOOD_LOG_STRIPPED.get()));
            this.tag(Tags.Blocks.STRIPPED_WOODS).add((Object)((Block)ModItems.FLASHING_ARCHWOOD_STRIPPED.get()));
            this.tag(BlockTags.LEAVES).add((Object)((Block)ModItems.FLASHING_LEAVES.get()));
            this.tag(this.ARCHWOOD_LEAVES).add((Object)((Block)ModItems.FLASHING_LEAVES.get()));
            this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)((Block)ModItems.FLASHING_LEAVES.get()));
            this.tag(BlockTags.SAPLINGS).add((Object)((Block)ModItems.FLASHING_SAPLING.get()));
            this.tag(BlockTagProvider.MAGIC_SAPLINGS).add((Object)((Block)ModItems.FLASHING_SAPLING.get()));
            this.tag(BlockTagProvider.MAGIC_PLANTS).add((Object)((Block)ModItems.FLASHING_POD.get()));
            this.tag(AQUARIUM_BONUS).addTag(BlockTags.CORALS).add((Object[])new Block[]{Blocks.SEAGRASS, Blocks.TALL_SEAGRASS, Blocks.KELP, Blocks.KELP_PLANT, Blocks.TURTLE_EGG});
            this.tag(SUMMER_CROPS).add((Object[])new Block[]{(Block)ModItems.FLASHING_POD.get(), (Block)ModItems.FLASHING_SAPLING.get()});
            this.tag(BlockTags.create((ResourceLocation)ArsNouveau.prefix((String)"whirlisprig/greatly_likes"))).add((Object)((Block)ModItems.GROUND_BLOSSOM.get()));
        }

        void logsTag(Block ... blocks) {
            this.tag(BlockTags.LOGS).add((Object[])blocks);
            this.tag(BlockTags.LOGS_THAT_BURN).add((Object[])blocks);
            this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object[])blocks);
        }

        void addPickMineable(int level, Block ... blocks) {
            block6: for (Block block : blocks) {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
                switch (level) {
                    case 1: {
                        this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)block);
                        continue block6;
                    }
                    case 2: {
                        this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object)block);
                        continue block6;
                    }
                    case 3: {
                        this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object)block);
                        continue block6;
                    }
                    case 4: {
                        this.tag(Tags.Blocks.NEEDS_NETHERITE_TOOL).add((Object)block);
                    }
                }
            }
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Block Tags";
        }
    }

    public static class AEItemTagsProvider
    extends ItemTagsProvider {
        String[] curioSlots = new String[]{"an_focus", "curio", "back", "belt", "body", "bracelet", "charm", "feet", "head", "hands", "necklace", "ring", "spellbook"};
        public static final TagKey<Item> CURIO_SPELL_FOCUS = AEItemTagsProvider.curiosTag("an_focus");
        public static final TagKey<Item> CURIO_BANGLE = AEItemTagsProvider.curiosTag("bracelet");
        public static final TagKey<Item> SUMMON_SHARDS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"magic_shards"));
        public static final TagKey<Item> SPELLBOOK = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"spellbook"));
        public static final TagKey<Item> PRISM_LENS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"spell_prism_lens"));
        public static final TagKey<Item> STRIPPED_LOGS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"stripped_logs"));
        public static final TagKey<Item> STRIPPED_WOODS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"stripped_wood"));

        static TagKey<Item> curiosTag(String key) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)key));
        }

        public AEItemTagsProvider(DataGenerator gen, CompletableFuture<HolderLookup.Provider> provider, BlockTagsProvider blockTagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(gen.getPackOutput(), provider, blockTagsProvider.contentsGetter(), "ars_elemental", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(SPELLBOOK).add((Object[])new Item[]{(Item)ItemsRegistry.NOVICE_SPELLBOOK.get(), (Item)ItemsRegistry.APPRENTICE_SPELLBOOK.get(), (Item)ItemsRegistry.ARCHMAGE_SPELLBOOK.get(), (Item)ItemsRegistry.CREATIVE_SPELLBOOK.get()}).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ars_omega", (String)"arcane_book"));
            this.tag(ModRegistry.SOULBOUND_ABLE).add((Object[])new Item[]{Items.WRITABLE_BOOK, Items.WRITTEN_BOOK, (Item)ModItems.CURIO_BAG.get(), (Item)ModItems.CASTER_BAG.get()});
            this.tag(CURIO_SPELL_FOCUS).add((Object[])new Item[]{(Item)ModItems.AIR_FOCUS.get(), (Item)ModItems.FIRE_FOCUS.get(), (Item)ModItems.EARTH_FOCUS.get(), (Item)ModItems.NECRO_FOCUS.get(), (Item)ModItems.WATER_FOCUS.get(), (Item)ModItems.LESSER_AIR_FOCUS.get(), (Item)ModItems.LESSER_FIRE_FOCUS.get(), (Item)ModItems.LESSER_EARTH_FOCUS.get(), (Item)ModItems.LESSER_WATER_FOCUS.get()});
            this.tag(CURIO_BANGLE).add((Object[])new Item[]{(Item)ModItems.AIR_BANGLE.get(), (Item)ModItems.FIRE_BANGLE.get(), (Item)ModItems.EARTH_BANGLE.get(), (Item)ModItems.WATER_BANGLE.get(), (Item)ModItems.ENCHANTER_BANGLE.get(), (Item)ModItems.ANIMA_BANGLE.get(), (Item)ModItems.SUMMON_BANGLE.get()});
            this.tag(SUMMON_SHARDS).add((Object[])new Item[]{(Item)ModItems.SIREN_SHARDS.get(), (Item)ItemsRegistry.DRYGMY_SHARD.get(), (Item)ItemsRegistry.STARBUNCLE_SHARD.get(), (Item)ItemsRegistry.WIXIE_SHARD.get(), (Item)ItemsRegistry.WHIRLISPRIG_SHARDS.get()});
            this.tag(PRISM_LENS).add((Object[])new Item[]{(Item)ModItems.ARC_LENS.get(), (Item)ModItems.HOMING_LENS.get(), (Item)ModItems.RGB_LENS.get(), (Item)ModItems.PIERCE_LENS.get(), (Item)ModItems.ACC_LENS.get(), (Item)ModItems.DEC_LENS.get(), (Item)ModItems.CHAIN_LENS.get()});
            this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
            this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
            this.copy(BlockTags.LOGS, ItemTags.LOGS);
            this.copy(BlockTags.LOGS_THAT_BURN, ItemTags.LOGS_THAT_BURN);
            this.tag(ItemTagProvider.ARCHWOOD_LOG_TAG).add((Object[])new Item[]{((Block)ModItems.FLASHING_ARCHWOOD_LOG.get()).asItem(), ((Block)ModItems.FLASHING_ARCHWOOD.get()).asItem(), ((Block)ModItems.FLASHING_ARCHWOOD_LOG_STRIPPED.get()).asItem(), ((Block)ModItems.FLASHING_ARCHWOOD_STRIPPED.get()).asItem()});
            this.tag(ItemTagProvider.SHADY_WIZARD_FRUITS).add((Object)((ArchfruitPod)ModItems.FLASHING_POD.get()).asItem());
            this.tag(Tags.Items.FOODS_FRUIT).add((Object)((ArchfruitPod)ModItems.FLASHING_POD.get()).asItem());
            Arrays.stream(this.curioSlots).map(AEItemTagsProvider::curiosTag).forEach(t -> this.tag(ModRegistry.SOULBOUND_ABLE).addOptionalTag(t.location()));
            this.tag(ModRegistry.SOULBOUND_ABLE).addTags(new TagKey[]{ItemTags.ARMOR_ENCHANTABLE, ItemTags.EQUIPPABLE_ENCHANTABLE, ItemTags.WEAPON_ENCHANTABLE, ItemTags.BOW_ENCHANTABLE, ItemTags.CROSSBOW_ENCHANTABLE, ItemTags.DURABILITY_ENCHANTABLE, SPELLBOOK, Tags.Items.TOOLS});
            this.tag(ModRegistry.SOULBOUND_ABLE).add((Object)ItemsRegistry.WAND.asItem()).add((Object)ItemsRegistry.ENCHANTERS_MIRROR.asItem()).add((Object)ItemsRegistry.ENCHANTERS_FISHING_ROD.asItem()).add((Object)ItemsRegistry.SCRY_CASTER.asItem()).add((Object)((Item)ModItems.SPELL_HORN.get())).addOptional(ResourceLocation.fromNamespaceAndPath((String)"not_enough_glyphs", (String)"spellbinder"));
            this.tag(ModRegistry.BLACKLIST_BAGGABLE).add((Object[])new Item[]{(Item)ModItems.CURIO_BAG.get(), (Item)ModItems.CASTER_BAG.get(), Items.BUNDLE});
            this.tag(STRIPPED_LOGS).add((Object)((Block)ModItems.FLASHING_ARCHWOOD_LOG_STRIPPED.get()).asItem());
            this.tag(STRIPPED_WOODS).add((Object)((Block)ModItems.FLASHING_ARCHWOOD_STRIPPED.get()).asItem());
            this.addArmorTags(ModItems.AIR_ARMOR);
            this.addArmorTags(ModItems.FIRE_ARMOR);
            this.addArmorTags(ModItems.EARTH_ARMOR);
            this.addArmorTags(ModItems.WATER_ARMOR);
            Object[] books = new Item[]{(Item)ModItems.AIR_CTOME.get(), (Item)ModItems.FIRE_CTOME.get(), (Item)ModItems.EARTH_CTOME.get(), (Item)ModItems.WATER_CTOME.get(), (Item)ModItems.NECRO_CTOME.get(), (Item)ModItems.SHAPERS_CTOME.get()};
            this.tag(ItemTags.LECTERN_BOOKS).add(books);
            this.tag(ItemTags.BOOKSHELF_BOOKS).add(books);
        }

        public void addArmorTags(ArmorSet set) {
            this.tag(ItemTags.ARMOR_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
            this.tag(ItemTags.EQUIPPABLE_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
            this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
            this.tag(ItemTags.HEAD_ARMOR_ENCHANTABLE).add((Object)set.getHat());
            this.tag(ItemTags.HEAD_ARMOR).add((Object)set.getHat());
            this.tag(ItemTags.CHEST_ARMOR_ENCHANTABLE).add((Object)set.getChest());
            this.tag(ItemTags.CHEST_ARMOR).add((Object)set.getChest());
            this.tag(ItemTags.LEG_ARMOR_ENCHANTABLE).add((Object)set.getLegs());
            this.tag(ItemTags.LEG_ARMOR).add((Object)set.getLegs());
            this.tag(ItemTags.FOOT_ARMOR_ENCHANTABLE).add((Object)set.getBoots());
            this.tag(ItemTags.FOOT_ARMOR).add((Object)set.getBoots());
        }

        @NotNull
        public String getName() {
            return "Ars Elemental Item Tags";
        }
    }
}

