/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.rituals;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ConfigHandler;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SquirrelRitual
extends AbstractRitual {
    public static String ID = "ritual_squirrels";

    public String getLangName() {
        return "Fast Squirrels";
    }

    public String getLangDescription() {
        return "Gives a long speed boost to Starbuncles in the area. Refresh buff every 30 seconds in a 15 cubes radius. Radius can be augmented to 30 with a gold block";
    }

    protected void tick() {
        ServerLevel level;
        int modifier = this.didConsumeItem((ItemLike)Items.GOLD_BLOCK) ? 2 : 1;
        Level level2 = this.getWorld();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).getGameTime() % (long)((Integer)ConfigHandler.Common.SQUIRREL_REFRESH_RATE.get()).intValue() == 0L && this.tile != null) {
            List entities = level.getEntitiesOfClass(Starbuncle.class, new AABB(this.tile.getBlockPos()).inflate((double)(15 * modifier)));
            for (Starbuncle entity : entities) {
                if (entity != null) {
                    entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 2400, 1, false, false));
                    entity.addEffect(new MobEffectInstance(MobEffects.JUMP, 2400, 0, false, false));
                }
                this.setNeedsSource(true);
            }
        }
    }

    public boolean canConsumeItem(ItemStack stack) {
        return this.getConsumedItems().isEmpty() && stack.getItem() == Items.GOLD_BLOCK;
    }

    public int getSourceCost() {
        return 150;
    }

    public ParticleColor getCenterColor() {
        return new ParticleColor(150 + this.rand.nextInt(105), 50 + this.rand.nextInt(100), this.rand.nextInt(25));
    }

    public ResourceLocation getRegistryName() {
        return ArsElemental.prefix(ID);
    }
}

