/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.rituals;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.PosCarryMEI;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.Tags;

public class RepulsionRitual
extends AbstractRitual {
    int backoff = 0;
    public static String ID = "ritual_repulsion";

    public String getName() {
        return "Repulsion";
    }

    public String getLangDescription() {
        return "Repel all mobs in a 15 block radius. Can be augmented with a bone to repel only undead mobs. Won't work on player and bosses.";
    }

    protected void tick() {
        ServerLevel level;
        boolean modifier = this.didConsumeItem((ItemLike)Items.BONE);
        Level level2 = this.getWorld();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).getGameTime() % (long)this.getBackoff() == 0L && this.tile != null) {
            List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(this.tile.getBlockPos()).inflate(15.0), modifier ? living -> living.getType().is(EntityTypeTags.UNDEAD) : living -> !(living instanceof Player) && !living.getType().is(Tags.EntityTypes.BOSSES));
            boolean flag = false;
            for (LivingEntity entity : entities) {
                if (entity == null || !(flag = entity.addEffect((MobEffectInstance)new PosCarryMEI((Holder<MobEffect>)ModPotions.REPEL, 200, 0, true, true, this.getPos())))) continue;
                this.setNeedsSource(true);
            }
            if (entities.isEmpty() && !flag) {
                this.setBackoff(60);
            } else {
                this.setBackoff(0);
            }
        }
    }

    public String getLangName() {
        return "Repulsion";
    }

    private int getBackoff() {
        return 20 + this.backoff;
    }

    private void setBackoff(int i) {
        this.backoff = i;
    }

    public void write(HolderLookup.Provider provider, CompoundTag tag) {
        super.write(provider, tag);
        tag.putInt("backoff", this.backoff);
    }

    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        this.backoff = tag.getInt("backoff");
    }

    public ResourceLocation getRegistryName() {
        return ArsElemental.prefix(ID);
    }

    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(125), this.rand.nextInt(225), this.rand.nextInt(125));
    }

    public boolean canConsumeItem(ItemStack stack) {
        return stack.getItem() == Items.BONE;
    }

    public int getSourceCost() {
        return 10;
    }
}

