/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.armor;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.perk.IEffectResolvePerk;
import com.hollingsworth.arsnouveau.api.perk.Perk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;

public class ShockPerk
extends Perk
implements IEffectResolvePerk {
    public static ShockPerk INSTANCE = new ShockPerk();

    public ShockPerk() {
        super(ArsElemental.prefix("thread_shock"));
    }

    public String getLangDescription() {
        return "Damaging effects cause the target to be shocked for a short duration before the effect resolves. Inflicts Static Charged at tier 3.";
    }

    public String getLangName() {
        return "Shocking";
    }

    public void onEffectPreResolve(EffectResolveEvent.Pre event, PerkInstance perkInstance) {
        AbstractEffect abstractEffect = event.resolveEffect;
        if (abstractEffect instanceof IDamageEffect) {
            LivingEntity livingEntity;
            EntityHitResult entityHitResult;
            IDamageEffect damageEffect = (IDamageEffect)abstractEffect;
            abstractEffect = event.rayTraceResult;
            if (abstractEffect instanceof EntityHitResult && (abstractEffect = (entityHitResult = (EntityHitResult)abstractEffect).getEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)abstractEffect) != event.shooter && damageEffect.canDamage(event.shooter, event.spellStats, event.context, event.resolver, entityHitResult.getEntity())) {
                int value = perkInstance.getSlot().value();
                livingEntity.addEffect(new MobEffectInstance(value < 3 ? com.hollingsworth.arsnouveau.setup.registry.ModPotions.SHOCKED_EFFECT : ModPotions.LIGHTNING_LURE, 100, value < 3 ? value : 1));
            }
        }
    }
}

