/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectConjureTerrain
extends ElementalAbstractEffect {
    public static EffectConjureTerrain INSTANCE = new EffectConjureTerrain();

    private EffectConjureTerrain() {
        super("conjure_terrain", "Conjure Terrain");
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockState toPlace;
        int amps = spellStats.getBuffCount((AbstractAugment)AugmentAmplify.INSTANCE);
        switch (amps) {
            case 1: {
                BlockState blockState = Blocks.COBBLESTONE.defaultBlockState();
                break;
            }
            case 2: {
                BlockState blockState = Blocks.COBBLED_DEEPSLATE.defaultBlockState();
                break;
            }
            default: {
                BlockState blockState = toPlace = Blocks.DIRT.defaultBlockState();
            }
        }
        if (spellStats.isRandomized() && toPlace.getBlock() == Blocks.DIRT) {
            switch (world.random.nextInt(5)) {
                case 0: {
                    BlockState blockState = Blocks.COARSE_DIRT.defaultBlockState();
                    break;
                }
                case 1: {
                    BlockState blockState = Blocks.PODZOL.defaultBlockState();
                    break;
                }
                case 2: {
                    BlockState blockState = Blocks.GRASS_BLOCK.defaultBlockState();
                    break;
                }
                case 4: {
                    BlockState blockState = Blocks.GRAVEL.defaultBlockState();
                    break;
                }
                default: {
                    BlockState blockState = toPlace = Blocks.DIRT.defaultBlockState();
                }
            }
        }
        if (spellContext.hasNextPart()) {
            while (spellContext.hasNextPart()) {
                AbstractSpellPart next = spellContext.nextPart();
                if (!(next instanceof AbstractEffect)) continue;
                if (next == EffectConjureWater.INSTANCE) {
                    toPlace = Blocks.MUD.defaultBlockState();
                    break;
                }
                if (next == EffectCrush.INSTANCE) {
                    BlockState blockState = toPlace = amps > 0 ? Blocks.SANDSTONE.defaultBlockState() : Blocks.SAND.defaultBlockState();
                    if (!spellStats.isRandomized() || !world.random.nextBoolean()) break;
                    toPlace = amps > 0 ? Blocks.RED_SANDSTONE.defaultBlockState() : Blocks.RED_SAND.defaultBlockState();
                    break;
                }
                if (next == EffectSmelt.INSTANCE && amps > 0) {
                    BlockState blockState = toPlace = amps > 1 ? Blocks.DEEPSLATE.defaultBlockState() : Blocks.STONE.defaultBlockState();
                    if (!spellStats.isRandomized() || toPlace.getBlock() != Blocks.STONE) break;
                    toPlace = switch (world.random.nextInt(6)) {
                        case 0 -> Blocks.DIORITE.defaultBlockState();
                        case 1 -> Blocks.ANDESITE.defaultBlockState();
                        case 2 -> Blocks.GRANITE.defaultBlockState();
                        case 3 -> Blocks.TUFF.defaultBlockState();
                        case 4 -> Blocks.CALCITE.defaultBlockState();
                        default -> Blocks.BLACKSTONE.defaultBlockState();
                    };
                    break;
                }
                spellContext.setCurrentIndex(spellContext.getCurrentIndex() - 1);
                break;
            }
        }
        GlyphEffectUtil.placeBlocks(rayTraceResult, world, shooter, spellStats, spellContext, resolver, toPlace);
    }

    public int getDefaultManaCost() {
        return 20;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentAmplify.INSTANCE, AugmentRandomize.INSTANCE});
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
        defaults.put(AugmentRandomize.INSTANCE.getRegistryName(), 1);
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.CONJURATION, SpellSchools.ELEMENTAL_EARTH});
    }

    public String getBookDescription() {
        return "Places Dirt or other terrain blocks. Can be augmented with AoE and Pierce to place more blocks, one Amplify to place cobblestone, two for cobbled deepslate, or one of the following combinations: Followed by ConjureWater, it will place Mud. If augmented with Amplify(s) and followed by Smelt, it will place Stone or Deepslate. If followed by Crush it will place Sand or, if amplified, Sandstone.";
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAmplify.INSTANCE, "Changes Dirt to Cobblestone to Cobbled Deepslate, or Sand to Sandstone.");
        map.put((AbstractAugment)AugmentRandomize.INSTANCE, "Uses a variant of the terrain block, ex. Red Sand instead of sand or Andesite in place of stone.");
    }
}

