/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.function.valuesource;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.queries.function.FunctionValues;
import org.apache.lucene.ars_nouveau.queries.function.ValueSource;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.MultiFloatFunction;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.MultiFunction;

public class MaxFloatFunction
extends MultiFloatFunction {
    public MaxFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "max";
    }

    @Override
    protected float func(int doc, FunctionValues[] valsArr) throws IOException {
        boolean noneFound = true;
        float val = Float.NEGATIVE_INFINITY;
        for (FunctionValues vals : valsArr) {
            if (!vals.exists(doc)) continue;
            noneFound = false;
            val = Math.max(vals.floatVal(doc), val);
        }
        if (noneFound) {
            return 0.0f;
        }
        return val;
    }

    @Override
    protected boolean exists(int doc, FunctionValues[] valsArr) throws IOException {
        return MultiFunction.anyExists(doc, valsArr);
    }
}

