/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ClientTransferHandlerPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<ClientTransferHandlerPacket> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("storage_transfer_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientTransferHandlerPacket> CODEC = StreamCodec.ofMember(ClientTransferHandlerPacket::toBytes, ClientTransferHandlerPacket::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<List<ItemStack>>> STACK_LIST_LIST_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()).apply(ByteBufCodecs.list((int)9));
    public List<List<ItemStack>> stacks;

    public ClientTransferHandlerPacket(List<List<ItemStack>> stacks) {
        this.stacks = stacks;
    }

    public ClientTransferHandlerPacket(RegistryFriendlyByteBuf pb) {
        this.stacks = (List)STACK_LIST_LIST_CODEC.decode((Object)pb);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf pb) {
        STACK_LIST_LIST_CODEC.encode((Object)pb, this.stacks);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer sender) {
        AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
        if (abstractContainerMenu instanceof CraftingTerminalMenu) {
            CraftingTerminalMenu terminalScreen = (CraftingTerminalMenu)abstractContainerMenu;
            terminalScreen.onTransferHandler(sender, this.stacks);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

