/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.api.registry.PotionProviderRegistry;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.MultiPotionContents;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class PotionFlask
extends ModItem {
    public PotionFlask() {
        this(ItemsRegistry.defaultItemProperties().stacksTo(1).durability(8).component(DataComponentRegistry.MULTI_POTION, (Object)new MultiPotionContents(0, PotionContents.EMPTY, 8)));
    }

    public PotionFlask(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        if (context.getLevel().isClientSide || !((blockEntity = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof PotionJarTile)) {
            return super.useOn(context);
        }
        PotionJarTile jarTile = (PotionJarTile)blockEntity;
        ItemStack thisStack = context.getItemInHand();
        IPotionProvider data = PotionProviderRegistry.from(thisStack);
        Player playerEntity = context.getPlayer();
        if (data == null || playerEntity == null) {
            return super.useOn(context);
        }
        PotionContents contents = data.getPotionData(thisStack);
        int usesRemaining = data.usesRemaining(thisStack);
        int maxUses = data.maxUses(thisStack);
        if (playerEntity.isShiftKeyDown() && usesRemaining > 0 && jarTile.getMaxFill() - jarTile.getAmount() >= 0 && jarTile.canAccept(contents, 100)) {
            jarTile.add(contents, 100);
            MultiPotionContents newContents = new MultiPotionContents(usesRemaining - 1, contents, maxUses);
            thisStack.set(DataComponentRegistry.MULTI_POTION, (Object)newContents);
        } else if (!playerEntity.isShiftKeyDown() && usesRemaining < maxUses && jarTile.getAmount() >= 100) {
            if (PotionUtil.arePotionContentsEqual(contents, jarTile.getData())) {
                MultiPotionContents newContents = new MultiPotionContents(usesRemaining + 1, contents, maxUses);
                jarTile.remove(100);
                thisStack.set(DataComponentRegistry.MULTI_POTION, (Object)newContents);
            } else if (usesRemaining == 0) {
                MultiPotionContents newContents = new MultiPotionContents(1, jarTile.getData(), maxUses);
                thisStack.set(DataComponentRegistry.MULTI_POTION, (Object)newContents);
                jarTile.remove(100);
            }
        }
        return super.useOn(context);
    }

    public int getMaxCapacity() {
        return 8;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level worldIn, @NotNull LivingEntity entityLiving) {
        Player player;
        Player playerentity;
        Player player2 = playerentity = entityLiving instanceof Player ? (player = (Player)entityLiving) : null;
        if (!worldIn.isClientSide) {
            MultiPotionContents data = (MultiPotionContents)stack.getOrDefault(DataComponentRegistry.MULTI_POTION, (Object)new MultiPotionContents(0, PotionContents.EMPTY, 8));
            for (MobEffectInstance effectinstance : data.contents().getAllEffects()) {
                if (((MobEffect)(effectinstance = this.getEffectInstance(effectinstance)).getEffect().value()).isInstantenous()) {
                    ((MobEffect)effectinstance.getEffect().value()).applyInstantenousEffect((Entity)playerentity, (Entity)playerentity, entityLiving, effectinstance.getAmplifier(), 1.0);
                    continue;
                }
                entityLiving.addEffect(new MobEffectInstance(effectinstance));
            }
            stack.set(DataComponentRegistry.MULTI_POTION, (Object)data.withCharges(data.charges() - 1));
        }
        return stack;
    }

    @NotNull
    public abstract MobEffectInstance getEffectInstance(MobEffectInstance var1);

    public int getDamage(ItemStack stack) {
        MultiPotionContents data = (MultiPotionContents)stack.getOrDefault(DataComponentRegistry.MULTI_POTION, (Object)new MultiPotionContents(0, PotionContents.EMPTY, 8));
        return this.getMaxDamage(stack) - data.charges();
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        return this.getMaxCapacity();
    }

    public boolean isDamaged(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(@NotNull ItemStack pStack) {
        return true;
    }

    public float getXpRepairRatio(@NotNull ItemStack stack) {
        return 0.0f;
    }

    public int getUseDuration(@NotNull ItemStack pStack, @NotNull LivingEntity p_344979_) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        MultiPotionContents data = (MultiPotionContents)stack.getOrDefault(DataComponentRegistry.MULTI_POTION, (Object)new MultiPotionContents(0, PotionContents.EMPTY, 8));
        return data.charges() > 0 ? ItemUtils.startUsingInstantly((Level)worldIn, (Player)playerIn, (InteractionHand)handIn) : InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        MultiPotionContents data = (MultiPotionContents)stack.getOrDefault(DataComponentRegistry.MULTI_POTION, (Object)new MultiPotionContents(0, PotionContents.EMPTY, 8));
        tooltip.add((Component)Component.translatable((String)"ars_nouveau.flask.charges", (Object[])new Object[]{data.charges()}).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
        PotionContents.addPotionTooltip((Iterable)data.contents().getAllEffects(), tooltip::add, (float)1.0f, (float)context.tickRate());
    }
}

