/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.mixin.jar.MobAccessorMixin;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.level.NoteBlockEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class JarEvents {
    @SubscribeEvent
    public static void onNoteblock(NoteBlockEvent.Play e) {
        if (e.getLevel().isClientSide()) {
            return;
        }
        BlockEntity blockEntity = e.getLevel().getBlockEntity(e.getPos().below());
        if (blockEntity instanceof MobJarTile) {
            MobJarTile mobJarTile = (MobJarTile)blockEntity;
            LevelAccessor level = e.getLevel();
            RandomSource random = level.getRandom();
            Entity entity = mobJarTile.getEntity();
            if (entity instanceof MobAccessorMixin) {
                MobAccessorMixin mob = (MobAccessorMixin)entity;
                SoundEvent soundEvent = mob.callGetAmbientSound();
                if (soundEvent == null) {
                    return;
                }
                e.getLevel().playSound(null, e.getPos(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
                e.setCanceled(true);
            } else {
                entity = mobJarTile.getEntity();
                if (entity instanceof LightningBolt) {
                    LightningBolt bolt = (LightningBolt)entity;
                    e.getLevel().playSound(null, e.getPos(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.BLOCKS, 10000.0f, 0.8f + random.nextFloat() * 0.2f);
                    e.getLevel().playSound(null, e.getPos(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.BLOCKS, 2.0f, random.nextFloat() * 0.2f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRide(EntityMountEvent mountEvent) {
        if (mountEvent.isDismounting()) {
            return;
        }
        if (mountEvent.getLevel().isClientSide) {
            return;
        }
        if (mountEvent.getEntityMounting() instanceof Player) {
            Entity beingMounted = mountEvent.getEntityBeingMounted();
            if (mountEvent.getLevel().isLoaded(beingMounted.getOnPos()) && mountEvent.getLevel().getBlockEntity(beingMounted.getOnPos()) instanceof MobJarTile) {
                mountEvent.setCanceled(true);
            }
        }
    }
}

