/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Alakarkinos;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.CrabState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.alakarkinos.DecideCrabActionState;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GetHatState
extends CrabState {
    BlockPos target;
    int ticks;
    boolean animHat;

    public GetHatState(Alakarkinos alakarkinos) {
        super(alakarkinos);
        this.target = alakarkinos.hatPos;
    }

    @Override
    @Nullable
    public CrabState tick() {
        if (this.target == null) {
            this.alakarkinos.hatPos = null;
            this.alakarkinos.getEntityData().set(Alakarkinos.HAS_HAT, (Object)true);
            return new DecideCrabActionState(this.alakarkinos);
        }
        BlockState hatState = this.alakarkinos.level.getBlockState(this.alakarkinos.hatPos);
        if (hatState.getBlock() != BlockRegistry.CRAB_HAT.get()) {
            this.alakarkinos.hatPos = null;
            this.alakarkinos.getEntityData().set(Alakarkinos.HAS_HAT, (Object)true);
            return new DecideCrabActionState(this.alakarkinos);
        }
        if (BlockUtil.distanceFrom(this.alakarkinos.blockPosition(), this.alakarkinos.hatPos) <= 1.5) {
            if (!this.animHat) {
                this.animHat = true;
                Networking.sendToNearbyClient(this.alakarkinos.level, (Entity)this.alakarkinos, (CustomPacketPayload)new PacketAnimEntity(this.alakarkinos.getId(), Alakarkinos.Animations.PICKUP_HAT.ordinal()));
            }
            ++this.ticks;
            if (this.ticks >= 18) {
                this.alakarkinos.hatPos = null;
                this.alakarkinos.getEntityData().set(Alakarkinos.HAS_HAT, (Object)true);
                this.alakarkinos.level.setBlockAndUpdate(this.target, Blocks.AIR.defaultBlockState());
                return new DecideCrabActionState(this.alakarkinos);
            }
        } else {
            this.alakarkinos.getNavigation().moveTo((double)this.alakarkinos.hatPos.getX(), (double)this.alakarkinos.hatPos.getY(), (double)this.alakarkinos.hatPos.getZ(), 1.0);
        }
        return super.tick();
    }
}

