/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.IStuckHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.MovementHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathFindingStatus;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathPointExtended;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathResult;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.Pathfinding;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingStuckHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.AbstractPathJob;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.PathJobMoveToPathable;
import com.hollingsworth.arsnouveau.common.util.Log;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesAdvancedPathNavigate
extends AbstractAdvancedPathNavigate {
    private static final double ON_PATH_SPEED_MULTIPLIER = 1.3;
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 2;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    private PathResult<AbstractPathJob> pathResult;
    private long pathStartTime = 0L;
    private BlockPos spawnedPos = BlockPos.ZERO;
    private BlockPos desiredPos;
    private int desiredPosTimeout = 0;
    private IStuckHandler stuckHandler;
    private boolean isSneaking = true;
    private double swimSpeedFactor = 1.0;

    public MinecoloniesAdvancedPathNavigate(Mob entity, Level world) {
        super(entity, world);
        entity.moveControl = new MovementHandler(entity);
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        this.getPathingOptions().setEnterDoors(true);
        this.nodeEvaluator.setCanOpenDoors(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.nodeEvaluator.setCanFloat(true);
        this.getPathingOptions().setCanSwim(true);
        this.stuckHandler = PathingStuckHandler.createStuckHandler().withTeleportSteps(6).withTeleportOnFullStuck();
    }

    @Override
    public BlockPos getDestination() {
        return this.destination;
    }

    @Override
    @Nullable
    public PathResult moveAwayFromXYZ(BlockPos avoid, double range, double speedFactor, boolean safeDestination) {
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(this.ourEntity.level, start, avoid, (int)range, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), (LivingEntity)this.ourEntity), null, speedFactor);
    }

    public PathResult setPathJob(AbstractPathJob job, BlockPos dest, double speedFactor) {
        this.stop();
        this.destination = dest;
        this.originalDestination = dest;
        if (dest != null) {
            this.desiredPos = dest;
            this.desiredPosTimeout = 1000;
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + String.valueOf(this.ourEntity), (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.pathResult = job.getResult();
        this.pathResult.startJob(Pathfinding.getExecutor());
        return this.pathResult;
    }

    public boolean isDone() {
        return (this.pathResult == null || this.pathResult.isDone() && this.pathResult.getStatus() != PathFindingStatus.CALCULATION_COMPLETE) && super.isDone();
    }

    public void tick() {
        int oldIndex;
        if (this.desiredPosTimeout > 0 && --this.desiredPosTimeout <= 0) {
            this.desiredPos = null;
        }
        if (this.pathResult != null) {
            if (!this.pathResult.isDone()) {
                return;
            }
            if (this.pathResult.getStatus() == PathFindingStatus.CALCULATION_COMPLETE) {
                this.processCompletedCalculationResult();
            }
        }
        int n = oldIndex = this.isDone() ? 0 : this.getPath().getNextNodeIndex();
        if (this.isSneaking) {
            this.isSneaking = false;
            this.mob.setShiftKeyDown(false);
        }
        this.ourEntity.setYya(0.0f);
        if (this.handleLadders(oldIndex)) {
            this.followThePath();
            this.stuckHandler.checkStuck(this);
            return;
        }
        if (this.handleRails()) {
            this.stuckHandler.checkStuck(this);
            return;
        }
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone()) {
            Vec3 vector3d2;
            BlockPos blockpos;
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 vector3d = this.getTempMobPos();
                Vec3 vector3d1 = this.path.getNextEntityPos((Entity)this.mob);
                if (vector3d.y > vector3d1.y && !this.mob.onGround() && Mth.floor((double)vector3d.x) == Mth.floor((double)vector3d1.x) && Mth.floor((double)vector3d.z) == Mth.floor((double)vector3d1.z)) {
                    this.path.advance();
                }
            }
            DebugPackets.sendPathFindingPacket((Level)this.level, (Mob)this.mob, (Path)this.path, (float)this.maxDistanceToWaypoint);
            if (!this.isDone() && this.level.isLoaded(blockpos = BlockPos.containing((Position)(vector3d2 = this.path.getNextEntityPos((Entity)this.mob))))) {
                this.mob.getMoveControl().setWantedPosition(vector3d2.x, this.level.getBlockState(blockpos.below()).isAir() ? vector3d2.y : MinecoloniesAdvancedPathNavigate.getSmartGroundY((BlockGetter)this.level, blockpos), vector3d2.z, this.speedModifier);
            }
        }
        if (this.pathResult != null && this.isDone()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            this.pathResult = null;
        }
        this.stuckHandler.checkStuck(this);
    }

    public static double getSmartGroundY(BlockGetter world, BlockPos pos) {
        BlockPos blockpos = pos.below();
        VoxelShape voxelshape = world.getBlockState(blockpos).getCollisionShape(world, blockpos);
        if (voxelshape.isEmpty() || voxelshape.max(Direction.Axis.Y) < 1.0) {
            return pos.getY();
        }
        return (double)blockpos.getY() + voxelshape.max(Direction.Axis.Y);
    }

    @Override
    public PathResult moveToXYZ(double x, double y, double z, double speedFactor) {
        int newX = Mth.floor((double)x);
        int newY = (int)y;
        int newZ = Mth.floor((double)z);
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobMoveToLocation && (this.pathResult.isComputing() || this.destination != null && this.destination.equals((Object)new BlockPos(newX, newY, newZ)) || this.originalDestination != null && this.originalDestination.equals((Object)new BlockPos(newX, newY, newZ)))) {
            return this.pathResult;
        }
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        this.desiredPos = new BlockPos(newX, newY, newZ);
        return this.setPathJob(new PathJobMoveToLocation(this.ourEntity.level, start, this.desiredPos, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), (LivingEntity)this.ourEntity), this.desiredPos, speedFactor);
    }

    public PathResult moveToClosestPosition(List<BlockPos> positions, double speedFactor) {
        if (this.pathResult != null && this.pathResult.getJob() instanceof PathJobMoveToLocation && (this.pathResult.isComputing() || this.destination != null && positions.contains(this.destination)) || this.originalDestination != null && positions.contains(this.originalDestination)) {
            return this.pathResult;
        }
        BlockPos start = AbstractPathJob.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveToPathable(this.ourEntity.level, start, positions, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), (LivingEntity)this.ourEntity), null, speedFactor);
    }

    @Override
    public boolean tryMoveToBlockPos(BlockPos pos, double speedFactor) {
        if (pos == null) {
            return false;
        }
        this.moveToXYZ(pos.getX(), pos.getY(), pos.getZ(), speedFactor);
        return true;
    }

    protected PathFinder createPathFinder(int p_179679_1_) {
        return null;
    }

    protected boolean canUpdatePath() {
        return true;
    }

    protected Vec3 getTempMobPos() {
        return this.ourEntity.position();
    }

    public Path createPath(BlockPos pos, int p_179680_2_) {
        return null;
    }

    protected boolean canMoveDirectly(Vec3 start, Vec3 end) {
        return super.canMoveDirectly(start, end);
    }

    public double getSpeedFactor() {
        if (this.ourEntity.isInWater()) {
            this.speedModifier = this.walkSpeedFactor * this.swimSpeedFactor;
            return this.speedModifier;
        }
        this.speedModifier = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void setSpeedModifier(double speedFactor) {
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + String.valueOf(this.ourEntity), (Throwable)new Exception());
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    public boolean moveTo(double x, double y, double z, double speedFactor) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return false;
        }
        this.moveToXYZ(x, y, z, speedFactor);
        return true;
    }

    public boolean moveTo(Entity entityIn, double speedFactor) {
        return this.tryMoveToBlockPos(entityIn.blockPosition(), speedFactor);
    }

    protected void trimPath() {
    }

    public boolean moveTo(Path path, double speedFactor) {
        if (path == null) {
            this.stop();
            return false;
        }
        this.pathStartTime = this.level.getGameTime();
        return super.moveTo(this.convertPath(path), speedFactor);
    }

    private Path convertPath(Path path) {
        int pathLength = path.getNodeCount();
        Path tempPath = null;
        if (pathLength > 0 && !(path.getNode(0) instanceof PathPointExtended)) {
            PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                Node point = path.getNode(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.x, point.y, point.z)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.getTarget(), path.canReach());
            PathPointExtended finalPoint = newPoints[pathLength - 1];
            this.destination = new BlockPos(finalPoint.x, finalPoint.y, finalPoint.z);
        }
        return tempPath == null ? path : tempPath;
    }

    private boolean processCompletedCalculationResult() {
        this.pathResult.getJob().synchToClient((LivingEntity)this.mob);
        this.moveTo(this.pathResult.getPath(), this.getSpeedFactor());
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        }
        return false;
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.isDone()) {
            @NotNull PathPointExtended pEx = (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex());
            PathPointExtended pExNext = this.getPath().getNodeCount() > this.getPath().getNextNodeIndex() + 1 ? (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex() + 1) : null;
            BlockPos pos = new BlockPos(pEx.x, pEx.y, pEx.z);
            if (pEx.isOnLadder() && pExNext != null && (pEx.y != pExNext.y || this.mob.getY() > (double)pEx.y) && this.level.getBlockState(pos).isLadder((LevelReader)this.level, pos, (LivingEntity)this.ourEntity)) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.isInWater()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.level.random.nextInt(20) == 0) {
                this.speedModifier = !pEx.isOnLadder() && pExNext != null && pExNext.isOnLadder() ? this.getSpeedFactor() / 4.0 : this.getSpeedFactor();
            }
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(Entity parEntity) {
        int blockX = (int)Math.round(parEntity.getX());
        int blockY = Mth.floor((double)(parEntity.getY() - 0.2));
        int blockZ = (int)Math.round(parEntity.getZ());
        return new BlockPos(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.isDone()) {
            PathPointExtended pExNext;
            PathPointExtended pEx = (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex());
            PathPointExtended pathPointExtended = pExNext = this.getPath().getNodeCount() > this.getPath().getNextNodeIndex() + 1 ? (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex() + 1) : null;
            if (pExNext != null && pEx.x == pExNext.x && pEx.z == pExNext.z) {
                PathPointExtended pathPointExtended2 = pExNext = this.getPath().getNodeCount() > this.getPath().getNextNodeIndex() + 2 ? (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex() + 2) : null;
            }
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        Vec3 vec3 = this.getPath().getNextEntityPos((Entity)this.ourEntity);
        BlockPos entityPos = BlockPos.containing((Position)this.ourEntity.position());
        if (vec3.distanceToSqr(this.ourEntity.getX(), vec3.y, this.ourEntity.getZ()) < Math.random() * 0.1) {
            double newSpeed = 0.3;
            switch (pEx.getLadderFacing()) {
                case NORTH: {
                    vec3 = vec3.add(0.0, 0.0, 1.0);
                    break;
                }
                case SOUTH: {
                    vec3 = vec3.add(0.0, 0.0, -1.0);
                    break;
                }
                case WEST: {
                    vec3 = vec3.add(1.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    vec3 = vec3.add(-1.0, 0.0, 0.0);
                    break;
                }
                case UP: {
                    vec3 = vec3.add(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    this.mob.setShiftKeyDown(true);
                    this.isSneaking = true;
                }
            }
            if (newSpeed > 0.0) {
                if (!(this.level.getBlockState(this.ourEntity.blockPosition()).getBlock() instanceof LadderBlock)) {
                    this.ourEntity.setDeltaMovement(this.ourEntity.getDeltaMovement().add(0.0, 0.1, 0.0));
                }
                this.ourEntity.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, newSpeed);
            } else {
                if (!this.level.getBlockState(entityPos.below()).isLadder((LevelReader)this.level, entityPos.below(), (LivingEntity)this.ourEntity)) {
                    return false;
                }
                this.ourEntity.setYya(-0.5f);
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        int curIndex = this.getPath().getNextNodeIndex();
        if (curIndex > 0 && curIndex + 1 < this.getPath().getNodeCount() && this.getPath().getNode((int)(curIndex - 1)).y != pEx.y) {
            oldIndex = curIndex + 1;
        }
        this.getPath().setNextNodeIndex(oldIndex);
        Vec3 Vector3d = this.getPath().getNextEntityPos((Entity)this.ourEntity);
        Vec3 vec3 = new Vec3(this.ourEntity.getX(), Vector3d.y, this.ourEntity.getZ());
        if (Vector3d.distanceToSqr(vec3) < 0.1 && Math.abs(this.ourEntity.getY() - Vector3d.y) < 0.5) {
            this.getPath().advance();
            if (this.isDone()) {
                return true;
            }
            Vector3d = this.getPath().getNextEntityPos((Entity)this.ourEntity);
        }
        this.ourEntity.getMoveControl().setWantedPosition(Vector3d.x, Vector3d.y, Vector3d.z, this.getSpeedFactor());
        return false;
    }

    protected void followThePath() {
        Vec3 next;
        this.getSpeedFactor();
        int curNode = this.path.getNextNodeIndex();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.path.getNodeCount()) {
            if (!(this.path.getNode(curNode) instanceof PathPointExtended)) {
                this.path = this.convertPath(this.path);
            }
            PathPointExtended pEx = (PathPointExtended)this.path.getNode(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.path.getNode(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vec3 vec3 = this.getTempMobPos();
                if (vec3.y - (double)pEx.y < 0.001) {
                    this.path.setNextNodeIndex(curNodeNext);
                }
                return;
            }
        }
        this.maxDistanceToWaypoint = 0.5f;
        boolean wentAhead = false;
        boolean isTracking = AbstractPathJob.DEBUG_DRAW;
        HashSet<BlockPos> reached = new HashSet<BlockPos>();
        for (int i = this.path.getNextNodeIndex(); i < Math.min(this.path.getNodeCount(), this.path.getNextNodeIndex() + 4); ++i) {
            next = this.path.getEntityPosAtNode((Entity)this.mob, i);
            if (!(Math.abs(this.mob.getX() - next.x) < (double)this.maxDistanceToWaypoint - Math.abs(this.mob.getY() - next.y) * 0.1) || !(Math.abs(this.mob.getZ() - next.z) < (double)this.maxDistanceToWaypoint - Math.abs(this.mob.getY() - next.y) * 0.1) || !(Math.abs(this.mob.getY() - next.y) <= 1.0)) continue;
            this.path.advance();
            wentAhead = true;
            if (!isTracking) continue;
            Node point = this.path.getNode(i);
            reached.add(new BlockPos(point.x, point.y, point.z));
        }
        if (isTracking) {
            AbstractPathJob.synchToClient(reached, this.ourEntity);
            reached.clear();
        }
        if (this.path.isDone()) {
            this.onPathFinish();
            return;
        }
        if (wentAhead) {
            return;
        }
        if (curNode >= this.path.getNodeCount() || curNode <= 1) {
            return;
        }
        Vec3 curr = this.path.getEntityPosAtNode((Entity)this.mob, curNode - 1);
        next = this.path.getEntityPosAtNode((Entity)this.mob, curNode);
        if (this.mob.position().distanceTo(curr) >= 2.0 && this.mob.position().distanceTo(next) >= 2.0) {
            for (int currentIndex = curNode - 1; currentIndex > 0; --currentIndex) {
                Vec3 tempoPos = this.path.getEntityPosAtNode((Entity)this.mob, currentIndex);
                if (this.mob.position().distanceTo(tempoPos) <= 1.0) {
                    this.path.setNextNodeIndex(currentIndex);
                    continue;
                }
                if (!isTracking) continue;
                reached.add(BlockPos.containing((double)tempoPos.x, (double)tempoPos.y, (double)tempoPos.z));
            }
        }
        if (isTracking) {
            AbstractPathJob.synchToClient(reached, this.ourEntity);
            reached.clear();
        }
    }

    private void onPathFinish() {
        this.stop();
    }

    public void recomputePath() {
    }

    protected void doStuckDetection(Vec3 positionVec3) {
    }

    public void stop() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        this.destination = null;
        super.stop();
    }

    public void setCanFloat(boolean canSwim) {
        super.setCanFloat(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getDesiredPos() {
        return this.desiredPos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }

    @Override
    public void setSwimSpeedFactor(double factor) {
        this.swimSpeedFactor = factor;
    }
}

