/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.WildenHunter;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.EnumSet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;

public class WildenSummon
extends Goal {
    private final WildenHunter entity;
    private int ticksSummoning;
    public final int maxSummoning = 45;

    public WildenSummon(WildenHunter entityIn) {
        this.entity = entityIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.entity.isAlive() && this.entity.getTarget() instanceof Player && this.entity.summonCooldown <= 0;
    }

    public boolean canContinueToUse() {
        return this.ticksSummoning < 45;
    }

    public void start() {
        super.start();
        Networking.sendToNearbyClient(this.entity.level, (Entity)this.entity, (CustomPacketPayload)new PacketAnimEntity(this.entity.getId(), WildenHunter.Animations.HOWL.ordinal()));
        this.entity.level.playSound(null, this.entity.blockPosition(), SoundEvents.WOLF_HOWL, SoundSource.HOSTILE, 1.0f, 0.3f);
        this.ticksSummoning = 0;
        this.entity.summonCooldown = 400;
        this.entity.getEntityData().set(WildenHunter.ANIM_STATE, (Object)WildenHunter.Animations.HOWL.name());
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        super.tick();
        ++this.ticksSummoning;
        if (this.ticksSummoning == 20) {
            SummonWolf wolf = new SummonWolf((EntityType<? extends Wolf>)((EntityType)ModEntities.SUMMON_WOLF.get()), this.entity.level);
            wolf.ticksLeft = 400;
            wolf.setPos(this.entity.getRandomX(1.0), this.entity.getY(), this.entity.getRandomZ(1.0));
            SummonWolf wolf2 = new SummonWolf((EntityType<? extends Wolf>)((EntityType)ModEntities.SUMMON_WOLF.get()), this.entity.level);
            wolf2.ticksLeft = 400;
            wolf2.setPos(this.entity.getRandomX(1.0), this.entity.getY(), this.entity.getRandomZ(1.0));
            if (this.entity.getTarget() != null) {
                wolf.setTarget(this.entity.getTarget());
                wolf2.setTarget(this.entity.getTarget());
            }
            wolf.setAggressive(true);
            wolf2.setAggressive(true);
            wolf.isWildenSummon = true;
            wolf2.isWildenSummon = true;
            this.entity.level.addFreshEntity((Entity)wolf);
            this.entity.level.addFreshEntity((Entity)wolf2);
        }
        if (this.ticksSummoning >= 45) {
            this.entity.getEntityData().set(WildenHunter.ANIM_STATE, (Object)WildenHunter.Animations.IDLE.name());
        }
    }
}

