/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityDummy
extends PathfinderMob
implements ISummon {
    @OnlyIn(value=Dist.CLIENT)
    private PlayerInfo playerInfo;
    public int ticksLeft;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(EntityDummy.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public EntityDummy(EntityType<? extends PathfinderMob> p_i48577_1_, Level p_i48577_2_) {
        super(p_i48577_1_, p_i48577_2_);
    }

    public EntityDummy(Level world) {
        super((EntityType)ModEntities.ENTITY_DUMMY.get(), world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(OWNER_UUID, Optional.of(Util.NIL_UUID));
    }

    public Iterable<ItemStack> getArmorSlots() {
        return new ArrayList<ItemStack>();
    }

    public boolean isSpectator() {
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.level.isClientSide) {
            if (this.level.getGameTime() % 10L == 0L && this.level.getPlayerByUUID(this.getOwnerUUID()) == null) {
                ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
                this.remove(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.level, null, false);
                return;
            }
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)this.level, this.blockPosition());
                this.remove(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.level, null, true);
            }
        }
    }

    public void die(DamageSource cause) {
        super.die(cause);
        this.onSummonDeath(this.level, cause, false);
    }

    public ItemStack getItemBySlot(EquipmentSlot p_184582_1_) {
        ItemStack heldStack;
        if (!this.level.isClientSide) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = heldStack = this.level.getPlayerByUUID(this.getOwnerUUID()) != null ? this.level.getPlayerByUUID(this.getOwnerUUID()).getItemBySlot(p_184582_1_) : ItemStack.EMPTY;
        if (heldStack.getItem() == BlockRegistry.MOB_JAR.asItem()) {
            return new ItemStack((ItemLike)BlockRegistry.MOB_JAR.asItem());
        }
        return heldStack;
    }

    public void setItemSlot(EquipmentSlot p_184201_1_, ItemStack p_184201_2_) {
    }

    public ResourceLocation getSkinTextureLocation() {
        PlayerInfo networkplayerinfo = this.getPlayerInfo();
        return networkplayerinfo == null ? DefaultPlayerSkin.getDefaultTexture() : networkplayerinfo.getSkin().texture();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected PlayerInfo getPlayerInfo() {
        if (this.playerInfo == null) {
            this.playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(this.getOwnerUUID());
        }
        return this.playerInfo;
    }

    public Component getName() {
        return this.level.getPlayerByUUID(this.getOwnerUUID()) == null ? Component.literal((String)"") : this.level.getPlayerByUUID(this.getOwnerUUID()).getName();
    }

    public Component getDisplayName() {
        MutableComponent iformattabletextcomponent = Component.literal((String)"");
        iformattabletextcomponent = iformattabletextcomponent.append((Component)PlayerTeam.formatNameForTeam((Team)this.getTeam(), (Component)this.getName()));
        return iformattabletextcomponent;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("left", this.ticksLeft);
        this.writeOwner(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.ticksLeft = tag.getInt("left");
        if (this.getOwnerUUID() != null) {
            this.setOwnerID(tag.getUUID("owner"));
        }
    }

    @Override
    public int getTicksLeft() {
        return this.ticksLeft;
    }

    @Override
    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.getEntityData().get(OWNER_UUID)).isEmpty() ? this.getUUID() : (UUID)((Optional)this.getEntityData().get(OWNER_UUID)).get();
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.getEntityData().set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSlim() {
        if (this.playerInfo != null) {
            return this.playerInfo.getSkin().model() == PlayerSkin.Model.SLIM;
        }
        return false;
    }
}

