/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class BiomeTagProvider
extends BiomeTagsProvider {
    public static TagKey<Biome> SUMMON_SPAWN_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsNouveau.prefix("summon_spawn"));
    public static TagKey<Biome> ARCHWOOD_BIOME_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsNouveau.prefix("archwood_biome"));
    public static TagKey<Biome> NO_MOB_SPAWN = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsNouveau.prefix("no_mob_spawn"));
    public static TagKey<Biome> BERRY_SPAWN = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ArsNouveau.prefix("berry_spawn"));

    public BiomeTagProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(pOutput, pProvider, "ars_nouveau", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.tag(ARCHWOOD_BIOME_TAG).add(BiomeRegistry.ARCHWOOD_FOREST);
        this.addTagToTags(ARCHWOOD_BIOME_TAG, BiomeTags.IS_FOREST, BiomeTags.IS_OVERWORLD, BiomeTags.HAS_VILLAGE_PLAINS);
        this.tag(SUMMON_SPAWN_TAG).addTags(new TagKey[]{BiomeTags.IS_OVERWORLD});
        this.tag(NO_MOB_SPAWN).addTags(new TagKey[]{Tags.Biomes.IS_MUSHROOM}).add(Biomes.DEEP_DARK);
        this.addTagToTags((TagKey<Biome>)BiomeTags.IS_TAIGA, BERRY_SPAWN);
        this.tag(BERRY_SPAWN).add(BiomeRegistry.ARCHWOOD_FOREST);
    }

    void addTagToTags(TagKey<Biome> biomeTag, TagKey<Biome> ... tags) {
        for (TagKey<Biome> tag : tags) {
            this.tag(tag).addTag(biomeTag);
        }
    }
}

