/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ScribesTile
extends ModdedTile
implements GeoBlockEntity,
ITickable,
Container,
ITooltipProvider,
IAnimationListener,
IWandable,
RecipeInput {
    private ItemStack stack = ItemStack.EMPTY;
    boolean synced;
    public List<ItemStack> consumedStacks = new ArrayList<ItemStack>();
    public RecipeHolder<GlyphRecipe> recipe;
    ResourceLocation recipeID;
    public boolean crafting;
    public int craftingTicks;
    public boolean autoYoink = true;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    AnimationController<ScribesTile> controller;

    public ScribesTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.SCRIBES_TABLE_TILE, pos, state);
    }

    @Override
    public void tick() {
        if (this.getBlockState().getValue((Property)ScribesBlock.PART) != ThreePartBlock.HEAD) {
            return;
        }
        if (!this.level.isClientSide && !this.synced) {
            this.updateBlock();
            this.synced = true;
        }
        if (this.craftingTicks > 0) {
            --this.craftingTicks;
        }
        if (this.recipeID != null && this.recipeID.equals((Object)ResourceLocation.withDefaultNamespace((String)""))) {
            this.recipe = null;
        }
        if (!(this.recipeID == null || this.recipeID.toString().isEmpty() || this.recipe != null && this.recipe.id().equals((Object)this.recipeID))) {
            this.recipe = this.level.getRecipeManager().byKeyTyped((RecipeType)RecipeRegistry.GLYPH_TYPE.get(), this.recipeID);
            this.setChanged();
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 5L == 0L && this.recipe != null) {
            boolean foundStack = false;
            List nearbyItems = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.getBlockPos()).inflate(2.0));
            for (ItemEntity e : nearbyItems) {
                if (!this.canConsumeItemstack(e.getItem())) continue;
                ItemStack copyStack = e.getItem().copy();
                copyStack.setCount(1);
                this.consumedStacks.add(copyStack);
                e.getItem().shrink(1);
                ParticleUtil.spawnTouchPacket(this.level, e.getOnPos(), ParticleColor.defaultParticleColor());
                this.updateBlock();
                foundStack = true;
                break;
            }
            if (!foundStack && this.level.getGameTime() % 20L == 0L && this.autoYoink) {
                this.takeNearby();
            }
            if (this.getRemainingRequired().isEmpty() && !this.crafting) {
                this.crafting = true;
                this.craftingTicks = 120;
                Networking.sendToNearbyClient(this.level, this.getBlockPos(), (CustomPacketPayload)new PacketOneShotAnimation(this.getBlockPos(), 0));
                this.updateBlock();
            }
        }
        if (this.level.isClientSide && this.craftingTicks == 0 && this.crafting) {
            this.crafting = false;
            this.setChanged();
        }
        if (!this.level.isClientSide && this.crafting && this.craftingTicks == 0 && this.recipe != null) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, this.getX() + 0.5, this.getY() + 1.1, this.getZ() + 0.5, ((GlyphRecipe)this.recipe.value()).output.copy()));
            this.recipe = null;
            this.recipeID = ResourceLocation.withDefaultNamespace((String)"");
            this.crafting = false;
            this.consumedStacks = new ArrayList<ItemStack>();
            this.updateBlock();
        }
    }

    public void takeNearby() {
        for (BlockPos bPos : BlockPos.betweenClosed((BlockPos)this.worldPosition.north(6).east(6).below(2), (BlockPos)this.worldPosition.south(6).west(6).above(2))) {
            IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, bPos, null);
            if (handler == null) continue;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.extractItem(i, 1, true);
                if (!this.canConsumeItemstack(stack)) continue;
                ItemStack stack1 = handler.extractItem(i, 1, false);
                stack1.copy().setCount(1);
                this.consumedStacks.add(stack1);
                EntityFlyingItem flyingItem = new EntityFlyingItem(this.level, bPos, this.getBlockPos());
                flyingItem.setStack(stack1);
                this.level.addFreshEntity((Entity)flyingItem);
                this.updateBlock();
                return;
            }
        }
    }

    public boolean consumeStack(ItemStack stack) {
        if (!this.canConsumeItemstack(stack)) {
            return false;
        }
        ItemStack copyStack = stack.split(1);
        this.consumedStacks.add(copyStack);
        ParticleUtil.spawnTouchPacket(this.level, this.getBlockPos().above(), ParticleColor.defaultParticleColor());
        this.updateBlock();
        return true;
    }

    public void refundConsumed() {
        for (ItemStack i : this.consumedStacks) {
            ItemEntity entity = new ItemEntity(this.level, this.getX(), this.getY(), this.getZ(), i);
            this.level.addFreshEntity((Entity)entity);
            this.consumedStacks = new ArrayList<ItemStack>();
        }
        if (this.recipe != null) {
            int exp = ((GlyphRecipe)this.recipe.value()).getExp();
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)new Vec3(this.getX(), this.getY(), this.getZ()), (int)exp);
            }
        }
        this.recipe = null;
        this.recipeID = null;
        this.craftingTicks = 0;
        this.crafting = false;
        this.updateBlock();
    }

    public void setRecipe(RecipeHolder<GlyphRecipe> recipe, Player player) {
        ScribesTile tile;
        if (ScribesTile.getTotalPlayerExperience(player) < ((GlyphRecipe)recipe.value()).exp && !player.isCreative()) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.not_enough_exp").withStyle(ChatFormatting.GOLD));
            return;
        }
        if (!player.isCreative()) {
            player.giveExperiencePoints(-((GlyphRecipe)recipe.value()).exp);
        }
        if ((tile = this.getLogicTile()) == null) {
            return;
        }
        tile.refundConsumed();
        tile.recipe = recipe;
        tile.recipeID = recipe.id();
        PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.scribes_table.started_crafting").withStyle(ChatFormatting.GOLD));
        tile.updateBlock();
    }

    public static int getTotalPlayerExperience(Player player) {
        return (int)((float)ScribesTile.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static int getLevelsFromExp(int exp) {
        if (exp <= 352) {
            return (int)(Math.sqrt(exp + 9) - 3.0);
        }
        if (exp <= 1507) {
            return (int)(8.1 + Math.sqrt(0.4 * ((double)exp - 195.975)));
        }
        return (int)(18.056 + Math.sqrt(0.222 * ((double)exp - 752.986)));
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level > 16 && level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    @Nullable
    public ScribesTile getLogicTile() {
        ScribesTile tile = this;
        if (!this.isMasterTile()) {
            BlockEntity tileEntity = this.level.getBlockEntity(this.getBlockPos().relative(ScribesBlock.getConnectedDirection(this.getBlockState())));
            tile = tileEntity instanceof ScribesTile ? (ScribesTile)tileEntity : null;
        }
        return tile;
    }

    public boolean isMasterTile() {
        return this.getBlockState().getValue((Property)ScribesBlock.PART) == ThreePartBlock.HEAD;
    }

    public boolean canConsumeItemstack(ItemStack stack) {
        if (this.recipe == null) {
            return false;
        }
        return this.getRemainingRequired().stream().anyMatch(i -> i.test(stack));
    }

    public List<Ingredient> getRemainingRequired() {
        if (this.consumedStacks.isEmpty()) {
            return ((GlyphRecipe)this.recipe.value()).inputs;
        }
        ArrayList<Ingredient> unaccountedIngredients = new ArrayList<Ingredient>();
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        for (ItemStack stack : this.consumedStacks) {
            remainingItems.add(stack.copy());
        }
        for (Ingredient ingred : ((GlyphRecipe)this.recipe.value()).inputs) {
            ItemStack matchingStack = null;
            for (ItemStack item : remainingItems) {
                if (!ingred.test(item)) continue;
                matchingStack = item;
                break;
            }
            if (matchingStack != null) {
                remainingItems.remove(matchingStack);
                continue;
            }
            unaccountedIngredients.add(ingred);
        }
        return unaccountedIngredients;
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.autoYoink = !this.autoYoink;
        this.updateBlock();
    }

    protected void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compound.getCompound("itemStack"));
        if (compound.contains("recipe")) {
            this.recipeID = ResourceLocation.tryParse((String)compound.getString("recipe"));
        }
        CompoundTag itemsTag = new CompoundTag();
        itemsTag.putInt("numStacks", this.consumedStacks.size());
        this.consumedStacks = NBTUtil.readItems(pRegistries, compound, "consumed");
        this.craftingTicks = compound.getInt("craftingTicks");
        this.crafting = compound.getBoolean("crafting");
        this.autoYoink = !compound.contains("autoYoink") || compound.getBoolean("autoYoink");
    }

    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(compound, pRegistries);
        if (!this.stack.isEmpty()) {
            Tag reagentTag = this.stack.save(pRegistries);
            compound.put("itemStack", reagentTag);
        }
        if (this.recipe != null) {
            compound.putString("recipe", this.recipe.id().toString());
        } else {
            compound.putString("recipe", "");
        }
        NBTUtil.writeItems(pRegistries, compound, "consumed", this.consumedStacks);
        compound.putInt("craftingTicks", this.craftingTicks);
        compound.putBoolean("crafting", this.crafting);
        compound.putBoolean("autoYoink", this.autoYoink);
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationState<E> event) {
        return PlayState.CONTINUE;
    }

    @Override
    public void startAnimation(int arg) {
        if (this.controller == null) {
            return;
        }
        this.controller.forceAnimationReset();
        this.controller.setAnimation(RawAnimation.begin().thenPlay("create_glyph2"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        this.controller = new AnimationController((GeoAnimatable)this, "controller", 1, this::idlePredicate);
        data.add(this.controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack == null || this.stack.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int pIndex) {
        return this.stack;
    }

    public int size() {
        return 0;
    }

    @NotNull
    public ItemStack removeItem(int pIndex, int pCount) {
        ItemStack removed = this.stack.copy().split(pCount);
        this.stack.shrink(pCount);
        this.updateBlock();
        return removed;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pIndex) {
        ItemStack stack = this.stack.copy();
        this.stack = ItemStack.EMPTY;
        this.updateBlock();
        return stack;
    }

    public void setItem(int pIndex, @NotNull ItemStack pStack) {
        this.stack = pStack;
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return true;
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
        this.updateBlock();
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (!this.isMasterTile()) {
            ScribesTile tile = this.getLogicTile();
            if (tile == null) {
                return;
            }
            tile.getTooltip(tooltip);
            return;
        }
        if (this.recipe != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.crafting", (Object[])new Object[]{((GlyphRecipe)this.recipe.value()).output.getHoverName()}));
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.scribes_table.throw_items").withStyle(ChatFormatting.GOLD));
        }
        if (!this.autoYoink) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.scribes_table.auto_take_disabled").withStyle(ChatFormatting.GOLD));
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
        this.updateBlock();
    }
}

