/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class CreateSpellButton
extends GuiImageButton {
    public Supplier<List<SpellValidationError>> errors;

    public CreateSpellButton(int x, int y, Button.OnPress onPress, Supplier<List<SpellValidationError>> errors) {
        super(x, y, DocAssets.SAVE_BUTTON, onPress);
        this.errors = errors;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.errors.get().isEmpty()) {
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.create"), this.x + 18, this.y + 4, -8355712, false);
        } else {
            MutableComponent textComponent = Component.translatable((String)"ars_nouveau.spell_book_gui.create").withStyle(s -> s.withStrikethrough(Boolean.valueOf(true)).withColor((TextColor)TextColor.parseColor((String)"#FFB2B2").getOrThrow()));
            graphics.drawString(Minecraft.getInstance().font, (Component)textComponent, this.x + 18, this.y + 4, -8355712, false);
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        if (!this.errors.get().isEmpty()) {
            boolean foundGlyphErrors = false;
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell.validation.crafting.invalid").withStyle(ChatFormatting.RED));
            for (SpellValidationError error : this.errors.get()) {
                if (error.getPosition() < 0) {
                    tooltip.add((Component)error.makeTextComponentExisting());
                    continue;
                }
                foundGlyphErrors = true;
            }
            if (foundGlyphErrors) {
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell.validation.crafting.invalid_glyphs"));
            }
        }
    }
}

