/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.NotNull;

public record SchoolTooltip(AbstractSpellPart part, boolean glyphItem) implements TooltipComponent
{
    public SchoolTooltip(AbstractSpellPart part) {
        this(part, false);
    }

    public List<SpellSchool> schools() {
        return this.part.spellSchools;
    }

    public String name() {
        return this.glyphItem ? Component.translatable((String)"ars_nouveau.glyph_of", (Object[])new Object[]{this.part.getLocaleName()}).getString() : this.part.getLocaleName();
    }

    public static class SchoolTooltipRenderer
    implements ClientTooltipComponent {
        static final int offset = 16;
        private final List<SpellSchool> schools;
        private final String name;

        public SchoolTooltipRenderer(SchoolTooltip pSchoolTooltip) {
            this.schools = pSchoolTooltip.schools();
            this.name = pSchoolTooltip.name();
        }

        public SchoolTooltipRenderer(AbstractSpellPart part) {
            this.schools = part.spellSchools;
            this.name = part.getLocaleName();
        }

        public int getHeight() {
            return 0;
        }

        public int getWidth(@NotNull Font font) {
            return font.width(this.name) + 16 + 16 * this.schools.size();
        }

        public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
            x += 16;
            for (SpellSchool school : this.schools) {
                guiGraphics.blit(school.getTexturePath(), x + font.width(this.name), y - 16, 0.0f, 0.0f, 16, 16, 16, 16);
                x += 16;
            }
        }
    }
}

