/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.source;

import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="ars_nouveau")
public class SourceManager {
    private Map<String, Set<ISpecialSourceProvider>> posMap = new ConcurrentHashMap<String, Set<ISpecialSourceProvider>>();
    public static SourceManager INSTANCE = new SourceManager();

    public void addInterface(Level world, ISpecialSourceProvider pos) {
        String key = world.dimension().location().toString();
        if (!this.posMap.containsKey(key)) {
            this.posMap.put(key, new HashSet());
        }
        this.posMap.get(key).add(pos);
    }

    @NotNull
    public Set<ISpecialSourceProvider> getSetForLevel(Level world) {
        String key = world.dimension().location().toString();
        return this.posMap.computeIfAbsent(key, k -> new HashSet());
    }

    public Set<ISpecialSourceProvider> getCopySetForLevel(Level world) {
        return new HashSet<ISpecialSourceProvider>(this.getSetForLevel(world));
    }

    @Nullable
    public ISpecialSourceProvider takeSourceNearby(BlockPos pos, Level world, int range, int amount) {
        for (ISpecialSourceProvider sourceInterface : this.getCopySetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().closerThan((Vec3i)pos, (double)range)) continue;
            sourceInterface.getSource().removeSource(amount);
            return sourceInterface;
        }
        return null;
    }

    @Nullable
    public ISpecialSourceProvider hasSourceNearby(BlockPos pos, Level world, int range, int amount) {
        for (ISpecialSourceProvider sourceInterface : this.getCopySetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().closerThan((Vec3i)pos, (double)range) || sourceInterface.getSource().getSource() < amount) continue;
            return sourceInterface;
        }
        return null;
    }

    public List<ISpecialSourceProvider> canGiveSourceNearby(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> list = new ArrayList<ISpecialSourceProvider>();
        for (ISpecialSourceProvider sourceInterface : this.getCopySetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().closerThan((Vec3i)pos, (double)range) || !sourceInterface.getSource().canAcceptSource()) continue;
            list.add(sourceInterface);
        }
        return list;
    }

    public List<ISpecialSourceProvider> canTakeSourceNearby(BlockPos pos, Level world, int range) {
        ArrayList<ISpecialSourceProvider> list = new ArrayList<ISpecialSourceProvider>();
        for (ISpecialSourceProvider sourceInterface : this.getCopySetForLevel(world)) {
            if (!sourceInterface.isValid() || !sourceInterface.getCurrentPos().closerThan((Vec3i)pos, (double)range) || sourceInterface.getSource().getSource() < 0) continue;
            list.add(sourceInterface);
        }
        return list;
    }

    public void tick(Level level) {
        if (level.getGameTime() % 60L == 0L) {
            HashSet<ISpecialSourceProvider> stale = new HashSet<ISpecialSourceProvider>();
            for (ISpecialSourceProvider iSourceInterface : this.getSetForLevel(level)) {
                if (iSourceInterface.isValid()) continue;
                stale.add(iSourceInterface);
            }
            Set<ISpecialSourceProvider> set = this.getSetForLevel(level);
            for (ISpecialSourceProvider iSourceInterface : stale) {
                set.remove(iSourceInterface);
            }
        }
    }

    private SourceManager() {
    }

    @SubscribeEvent
    public static void serverTick(LevelTickEvent.Post e) {
        if (e.getLevel().isClientSide) {
            return;
        }
        INSTANCE.tick(e.getLevel());
    }
}

