/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.potion;

import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.NotNull;

public interface IPotionProvider {
    @NotNull
    public PotionContents getPotionData(ItemStack var1);

    public int usesRemaining(ItemStack var1);

    public int maxUses(ItemStack var1);

    default public int roomLeft(ItemStack stack) {
        return this.maxUses(stack) - this.usesRemaining(stack);
    }

    public void consumeUses(ItemStack var1, int var2, @Nullable LivingEntity var3);

    public void addUse(ItemStack var1, int var2, @Nullable LivingEntity var3);

    public void setData(PotionContents var1, int var2, int var3, ItemStack var4);

    default public MobEffectInstance getEffectInstance(MobEffectInstance effectinstance) {
        return effectinstance;
    }

    default public void applyEffects(ItemStack stack, Entity source, Entity inDirectSource, LivingEntity target) {
        for (MobEffectInstance effectinstance : this.getPotionData(stack).getAllEffects()) {
            if (((MobEffect)(effectinstance = this.getEffectInstance(effectinstance)).getEffect().value()).isInstantenous()) {
                ((MobEffect)effectinstance.getEffect().value()).applyInstantenousEffect(source, inDirectSource, target, effectinstance.getAmplifier(), 1.0);
                continue;
            }
            target.addEffect(new MobEffectInstance(effectinstance), source);
        }
    }

    default public void addTooltip(ItemStack stack, List<Component> tooltips) {
        PotionContents potionStack = this.getPotionData(stack);
        potionStack.addPotionTooltip(tooltips::add, 1.0f, 20.0f);
    }

    default public boolean isEmpty(ItemStack stack) {
        return PotionUtil.isEmpty(this.getPotionData(stack)) || this.usesRemaining(stack) <= 0;
    }
}

