/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.subject;

import com.ssblur.scriptor.api.word.Subject;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.EntityTargetable;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J$\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/ssblur/scriptor/word/subject/StormSubject;", "Lcom/ssblur/scriptor/api/word/Subject;", "<init>", "()V", "cost", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "getTargets", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "caster", "spell", "Lcom/ssblur/scriptor/word/Spell;", "scriptor"})
public final class StormSubject
extends Subject {
    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(8.0, Word.COSTTYPE.MULTIPLICATIVE);
    }

    @Override
    @NotNull
    public CompletableFuture<List<Targetable>> getTargets(@NotNull Targetable caster, @NotNull Spell spell) {
        Intrinsics.checkNotNullParameter((Object)caster, (String)"caster");
        Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
        ArrayList<Targetable> targets = new ArrayList<Targetable>();
        Random random = new Random();
        int radius = 4;
        int limit = 12;
        BlockPos center = caster.getTargetBlockPos();
        BlockPos pos = null;
        for (int i = 0; i < limit; ++i) {
            pos = center.offset(random.nextInt(radius * 2 - radius), 3, random.nextInt(radius * 2 - radius));
            for (int j = 0; j < 3 && caster.getLevel().getBlockState(pos.below()).canBeReplaced(); ++j) {
                pos = pos.below();
            }
            List entities = caster.getLevel().getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (double)1.0, (double)1.0, (double)1.0));
            if (entities.size() > 0) {
                for (LivingEntity entity : entities) {
                    Intrinsics.checkNotNull((Object)entity);
                    targets.add(new EntityTargetable((Entity)entity));
                }
                continue;
            }
            targets.add(new Targetable(caster.getLevel(), pos));
        }
        CompletableFuture<List<Targetable>> result = new CompletableFuture<List<Targetable>>();
        result.complete(targets);
        return result;
    }
}

