/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.scriptor.word.descriptor.target;

import com.ssblur.scriptor.api.word.Descriptor;
import com.ssblur.scriptor.api.word.Word;
import com.ssblur.scriptor.helpers.targetable.Targetable;
import com.ssblur.scriptor.word.descriptor.target.TargetDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0003\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR2\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\n0\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/ssblur/scriptor/word/descriptor/target/OffsetDescriptor;", "Lcom/ssblur/scriptor/api/word/Descriptor;", "Lcom/ssblur/scriptor/word/descriptor/target/TargetDescriptor;", "cost", "", "<init>", "(D)V", "getCost", "()D", "transforms", "", "Ljava/util/function/BiConsumer;", "Lcom/ssblur/scriptor/helpers/targetable/Targetable;", "getTransforms", "()Ljava/util/List;", "setTransforms", "(Ljava/util/List;)V", "modifyTargets", "", "originalTargetables", "owner", "Lcom/ssblur/scriptor/api/word/Word$Cost;", "replacesSubjectCost", "", "allowsDuplicates", "right", "left", "up", "down", "forward", "backwards", "duplicate", "scriptor"})
public final class OffsetDescriptor
extends Descriptor
implements TargetDescriptor {
    private final double cost;
    @NotNull
    private List<BiConsumer<Targetable, List<Targetable>>> transforms;

    public OffsetDescriptor(double cost) {
        this.cost = cost;
        this.transforms = new ArrayList();
    }

    public final double getCost() {
        return this.cost;
    }

    @NotNull
    public final List<BiConsumer<Targetable, List<Targetable>>> getTransforms() {
        return this.transforms;
    }

    public final void setTransforms(@NotNull List<BiConsumer<Targetable, List<Targetable>>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.transforms = list;
    }

    @Override
    @NotNull
    public List<Targetable> modifyTargets(@NotNull List<? extends Targetable> originalTargetables, @NotNull Targetable owner) {
        Intrinsics.checkNotNullParameter(originalTargetables, (String)"originalTargetables");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List output = new ArrayList();
        for (Targetable targetable : originalTargetables) {
            for (BiConsumer<Targetable, List<Targetable>> transform : this.transforms) {
                transform.accept(targetable, output);
            }
        }
        return output;
    }

    @Override
    @NotNull
    public Word.Cost cost() {
        return new Word.Cost(1.25, Word.COSTTYPE.MULTIPLICATIVE);
    }

    @Override
    public boolean replacesSubjectCost() {
        return false;
    }

    @Override
    public boolean allowsDuplicates() {
        return true;
    }

    @NotNull
    public final OffsetDescriptor right() {
        this.transforms.add(OffsetDescriptor::right$lambda$0);
        return this;
    }

    @NotNull
    public final OffsetDescriptor left() {
        this.transforms.add(OffsetDescriptor::left$lambda$1);
        return this;
    }

    @NotNull
    public final OffsetDescriptor up() {
        this.transforms.add(OffsetDescriptor::up$lambda$2);
        return this;
    }

    @NotNull
    public final OffsetDescriptor down() {
        this.transforms.add(OffsetDescriptor::down$lambda$3);
        return this;
    }

    @NotNull
    public final OffsetDescriptor forward() {
        this.transforms.add(OffsetDescriptor::forward$lambda$4);
        return this;
    }

    @NotNull
    public final OffsetDescriptor backwards() {
        this.transforms.add(OffsetDescriptor::backwards$lambda$5);
        return this;
    }

    @NotNull
    public final OffsetDescriptor duplicate() {
        this.transforms.add(OffsetDescriptor::duplicate$lambda$6);
        return this;
    }

    private static final void right$lambda$0(Targetable originalTargetable, List output) {
        Intrinsics.checkNotNullParameter((Object)originalTargetable, (String)"originalTargetable");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Targetable targetable = originalTargetable;
        targetable = targetable.simpleCopy();
        Direction direction = targetable.getFacing();
        Vec3 pos = targetable.getTargetPos();
        pos = direction.getAxis() != Direction.Axis.Y ? pos.add(Vec3.atLowerCornerOf((Vec3i)direction.getClockWise().getNormal())) : pos.add(Vec3.atLowerCornerOf((Vec3i)Direction.EAST.getNormal()));
        targetable.setTargetPos(pos);
        output.add(targetable);
    }

    private static final void left$lambda$1(Targetable originalTargetable, List output) {
        Intrinsics.checkNotNullParameter((Object)originalTargetable, (String)"originalTargetable");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Targetable targetable = originalTargetable;
        targetable = targetable.simpleCopy();
        Direction direction = targetable.getFacing();
        Vec3 pos = targetable.getTargetPos();
        pos = direction.getAxis() != Direction.Axis.Y ? pos.add(Vec3.atLowerCornerOf((Vec3i)direction.getCounterClockWise().getNormal())) : pos.add(Vec3.atLowerCornerOf((Vec3i)Direction.WEST.getNormal()));
        targetable.setTargetPos(pos);
        output.add(targetable);
    }

    private static final void up$lambda$2(Targetable originalTargetable, List output) {
        Intrinsics.checkNotNullParameter((Object)originalTargetable, (String)"originalTargetable");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Targetable targetable = originalTargetable;
        targetable = targetable.simpleCopy();
        Direction direction = targetable.getFacing();
        Vec3 pos = targetable.getTargetPos();
        pos = direction.getAxis() != Direction.Axis.Y ? pos.add(Vec3.atLowerCornerOf((Vec3i)Direction.UP.getNormal())) : pos.add(Vec3.atLowerCornerOf((Vec3i)Direction.NORTH.getNormal()));
        targetable.setTargetPos(pos);
        output.add(targetable);
    }

    private static final void down$lambda$3(Targetable originalTargetable, List output) {
        Intrinsics.checkNotNullParameter((Object)originalTargetable, (String)"originalTargetable");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Targetable targetable = originalTargetable;
        targetable = targetable.simpleCopy();
        Direction direction = targetable.getFacing();
        Vec3 pos = targetable.getTargetPos();
        pos = direction.getAxis() != Direction.Axis.Y ? pos.add(Vec3.atLowerCornerOf((Vec3i)Direction.DOWN.getNormal())) : pos.add(Vec3.atLowerCornerOf((Vec3i)Direction.SOUTH.getNormal()));
        targetable.setTargetPos(pos);
        output.add(targetable);
    }

    private static final void forward$lambda$4(Targetable originalTargetable, List output) {
        Intrinsics.checkNotNullParameter((Object)originalTargetable, (String)"originalTargetable");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Targetable targetable = originalTargetable;
        targetable = targetable.simpleCopy();
        Direction direction = targetable.getFacing();
        Vec3 pos = targetable.getTargetPos();
        pos = pos.add(Vec3.atLowerCornerOf((Vec3i)direction.getNormal()));
        targetable.setTargetPos(pos);
        output.add(targetable);
    }

    private static final void backwards$lambda$5(Targetable originalTargetable, List output) {
        Intrinsics.checkNotNullParameter((Object)originalTargetable, (String)"originalTargetable");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Targetable targetable = originalTargetable;
        targetable = targetable.simpleCopy();
        Direction direction = targetable.getFacing();
        Vec3 pos = targetable.getTargetPos();
        pos = pos.add(Vec3.atLowerCornerOf((Vec3i)direction.getOpposite().getNormal()));
        targetable.setTargetPos(pos);
        output.add(targetable);
    }

    private static final void duplicate$lambda$6(Targetable targetable, List output) {
        Intrinsics.checkNotNullParameter((Object)targetable, (String)"targetable");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.add(targetable.simpleCopy());
    }
}

